//---------------------------------------------------------------------------
#ifndef GLmainH
#define GLmainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <gl\gl.h>
#include <gl\glu.h>
//---------------------------------------------------------------------------
class TFormMain : public TForm
{
__published:
	void __fastcall FormCreate(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
    void __fastcall FormResize(TObject *Sender);
    void __fastcall FormPaint(TObject *Sender);
    void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
private:
    HDC hDC;
    HGLRC hRC;
    Graphics::TBitmap* bitmap;
    GLuint texture[3];
    GLint filter;

    BOOL light;
    BOOL blend;

    GLfloat	xrot;									// X Rotation
    GLfloat	yrot;									// Y Rotation
	GLfloat xspeed;									// X Rotation Speed
	GLfloat yspeed;									// Y Rotation Speed
public:
    __fastcall TFormMain(TComponent* Owner);
    void __fastcall IdleLoop(TObject*, bool&);
    int __fastcall SetPixelFormatDescriptor(BYTE);
    int InitGL();
    int SetupTextures();
    void SetupLights();
    void RenderGLScene();
    void DrawObjects();
};
//---------------------------------------------------------------------------
extern PACKAGE TFormMain *FormMain;
//---------------------------------------------------------------------------
#endif
