//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "GLmain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;

int twinkle;
const num=50;

typedef struct
{
   	int r, g, b;
    GLfloat dist;
    GLfloat angle;
}stars;
stars star[num];

GLfloat	zoom=-15.0f;
GLfloat tilt=90.0f;
GLfloat	spin;
GLuint loop;

//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner)
    : TForm(Owner)
{
    Application->OnIdle = IdleLoop;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::IdleLoop(TObject*, bool& done)
{
    if(FormMain->Active==TRUE)
    {
    	done = false;
    	RenderGLScene();
    	SwapBuffers(hDC);
    }
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormCreate(TObject *Sender)
{
    hDC = GetDC(Handle);
    if(!SetPixelFormatDescriptor(24))
    	Close();
    hRC = wglCreateContext(hDC);
    if(hRC == NULL)
    	ShowMessage(":-)~ hRC == NULL");
    if(wglMakeCurrent(hDC, hRC) == false)
    	ShowMessage("Could not MakeCurrent");

    if(!InitGL())
       	ShowMessage("GL initialization failed.");
}
//---------------------------------------------------------------------------
int __fastcall TFormMain::SetPixelFormatDescriptor(BYTE bits)
{
	int PixelFormat;

    static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
    	sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
        0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
        0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)
		0,											// No Stencil Buffer
        0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
        0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
    };

    if((PixelFormat=ChoosePixelFormat(hDC, &pfd))==0)
    {
    	MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK);
        return FALSE;
    }
    if(!SetPixelFormat(hDC, PixelFormat, &pfd))
    {
    	MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK);
        return FALSE;
    }

    return TRUE;
}
//---------------------------------------------------------------------------
int TFormMain::InitGL()
{
    if (!SetupTextures())
    	return FALSE;

	glEnable(GL_TEXTURE_2D);
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);

    glClearDepth(1.0f);							// Depth Buffer Setup
	//glEnable(GL_DEPTH_TEST);					// Enables Depth Testing
	//glDepthFunc(GL_LEQUAL);					// The Type Of Depth Test To Do

    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations

    SetupLights();

	glBlendFunc(GL_SRC_ALPHA,GL_ONE);		// Blending Function For Translucency Based On Source Alpha Value
    glEnable(GL_BLEND);

    for (loop=0; loop<num; loop++)
	{
    	star[loop].angle=0.0f;
        star[loop].dist=(float(loop)/num)*5.0f;
		star[loop].r=rand()%256;
		star[loop].g=rand()%256;
		star[loop].b=rand()%256;
    }

	return TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormResize(TObject *Sender)
{
	GLfloat w = ClientWidth;
    GLfloat h = ClientHeight;

    if(!h) h=1;
    glViewport(0, 0, w, h);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45.0f, w/h, 0.1f, 100.0f);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}
//---------------------------------------------------------------------------
void TFormMain::RenderGLScene()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
    DrawObjects();
    glFlush();
}
//---------------------------------------------------------------------------
void TFormMain::DrawObjects()
{
    glBindTexture(GL_TEXTURE_2D, texture[0]);

    for (loop=0; loop<num; loop++)
    {
    	glLoadIdentity();
		glTranslatef(0.0f,0.0f,zoom);
		glRotatef(tilt,1.0f,0.0f,0.0f);
        glRotatef(star[loop].angle,0.0f,1.0f,0.0f);
		glTranslatef(star[loop].dist,0.0f,0.0f);
        glRotatef(-star[loop].angle,0.0f,1.0f,0.0f);
		glRotatef(-tilt,1.0f,0.0f,0.0f);

        if (twinkle)
        {
			glColor4ub(star[(num-loop)-1].r,star[(num-loop)-1].g,star[(num-loop)-1].b,255);
			glBegin(GL_QUADS);
				glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,-1.0f, 0.0f);
				glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,-1.0f, 0.0f);
				glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f, 1.0f, 0.0f);
				glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, 1.0f, 0.0f);
			glEnd();
        }

        glRotatef(spin,0.0f,0.0f,1.0f);
		glColor4ub(star[loop].r,star[loop].g,star[loop].b,255);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,-1.0f, 0.0f);
			glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,-1.0f, 0.0f);
			glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f, 1.0f, 0.0f);
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, 1.0f, 0.0f);
        glEnd();

        spin+=0.01f;
		star[loop].angle+=loop/float(num);
		star[loop].dist-=0.01f;

        if (star[loop].dist<0.0f)
        {
			star[loop].dist=5.0f;
			star[loop].r=rand()%256;
			star[loop].g=rand()%256;
			star[loop].b=rand()%256;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormPaint(TObject *Sender)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glFlush();
    DrawObjects();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormDestroy(TObject *Sender)
{
    wglMakeCurrent(NULL, NULL);
    wglDeleteContext(hRC);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
    if(Key == VK_ESCAPE)
        Close();
	if(Key == VK_F1)
       	twinkle=!twinkle;

    if (Key == VK_UP)
    	tilt-=0.5f;
    if (Key == VK_DOWN)
    	tilt+=0.5f;
    if (Key == VK_PRIOR)
    	zoom-=0.2f;
    if (Key == VK_NEXT)
    	zoom+=0.2f;

}
//---------------------------------------------------------------------------
int TFormMain::SetupTextures()
{
    glGenTextures(1, &texture[0]);

    bitmap = new Graphics::TBitmap;
    try
    {
    	bitmap->LoadFromFile("star.bmp");
    }
    catch (...)
    {
     	return FALSE;
    }

    const int size=64;
    GLubyte bits[size][size][3];
    for(int i = 0; i < size; i++)
    {
    	for(int j = 0; j < size; j++)
        {
            bits[i][j][0]= (GLbyte)GetRValue(bitmap->Canvas->Pixels[i][j]);
            bits[i][j][1]= (GLbyte)GetGValue(bitmap->Canvas->Pixels[i][j]);
            bits[i][j][2]= (GLbyte)GetBValue(bitmap->Canvas->Pixels[i][j]);
        }
    }

	//glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
    glBindTexture(GL_TEXTURE_2D, texture[0]);
    glTexImage2D(GL_TEXTURE_2D, 0, 3, size, size, 0, GL_RGB, GL_UNSIGNED_BYTE, bits);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

    delete bitmap;

    return TRUE;
}

void TFormMain::SetupLights()
{
	GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[]= { 0.0f, 0.0f, 2.0f, 1.0f };

    glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
    glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
    glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);

    glEnable(GL_LIGHT1);
}
