//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <stdio.h>
#pragma hdrstop

#include "GLmain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;

int light=0;						// Lighting ON/OFF
int	part1, part2;				// Disk start/end
int p1=0, p2=1;					// Angles for disk animation
GLfloat Angle=0;				// Angle for cylinder animation;
GLfloat	xrot=0;					// X Rotation
GLfloat	yrot=0;					// Y Rotation
GLfloat xspeed=0;               // X Rotation speed
GLfloat yspeed=0;				// Y Rotation speed
GLfloat	zoom=-5.0f;				// Depth Into The Screen
GLuint object=0;				// Which Object To Draw

GLUquadricObj *quadratic;		// Storage For Quadratic Objects

//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner)
	: TForm(Owner)
{
	Application->OnIdle = IdleLoop;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::IdleLoop(TObject*, bool& done)
{
	if(FormMain->Active==TRUE)
	{
		done = false;
		RenderGLScene();
		SwapBuffers(hDC);
	}
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormCreate(TObject *Sender)
{
	hDC = GetDC(Handle);
	if(!SetPixelFormatDescriptor(24))
		Close();
	hRC = wglCreateContext(hDC);
	if(hRC == NULL)
		ShowMessage("CreateContext failed.");
	if(wglMakeCurrent(hDC, hRC) == false)
		ShowMessage("MakeCurrent failed.");

	if(!InitGL())
		ShowMessage("GL initialization failed.");
}
//---------------------------------------------------------------------------
int __fastcall TFormMain::SetPixelFormatDescriptor(BYTE bits)
{
	int PixelFormat;

	static	PIXELFORMATDESCRIPTOR pfd=	// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),	// Size Of This Pixel Format Descriptor
		1,								// Version Number
		PFD_DRAW_TO_WINDOW |			// Format Must Support Window
		PFD_SUPPORT_OPENGL |			// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,				// Must Support Double Buffering
		PFD_TYPE_RGBA,					// Request An RGBA Format
		bits,							// Select Our Color Depth
		0, 0, 0, 0, 0, 0,				// Color Bits Ignored
		0,								// No Alpha Buffer
		0,								// Shift Bit Ignored
		0,								// No Accumulation Buffer
		0, 0, 0, 0,						// Accumulation Bits Ignored
		16,								// 16Bit Z-Buffer (Depth Buffer)
		0,								// No Stencil Buffer
		0,								// No Auxiliary Buffer
		PFD_MAIN_PLANE,					// Main Drawing Layer
		0,								// Reserved
		0, 0, 0							// Layer Masks Ignored
	};

	if((PixelFormat=ChoosePixelFormat(hDC, &pfd))==0)
	{
		MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK);
		return FALSE;
	}
	if(!SetPixelFormat(hDC, PixelFormat, &pfd))
	{
		MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK);
		return FALSE;
	}

	return TRUE;
}
//---------------------------------------------------------------------------
int TFormMain::InitGL()
{
	if (!SetupTextures())
		return FALSE;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, texture[0]);

	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);

	glClearDepth(1.0f);							// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);					// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);						// The Type Of Depth Test To Do

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations

	SetupLights();

	//glEnable(GL_COLOR_MATERIAL);

	quadratic=gluNewQuadric();			// Create A Pointer To The Quadric Object
	gluQuadricNormals(quadratic, GLU_SMOOTH);	// Create Smooth Normals
	gluQuadricTexture(quadratic, GL_TRUE);		// Create Texture Coords

	return TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormResize(TObject *Sender)
{
	GLfloat w = ClientWidth;
	GLfloat h = ClientHeight;

	if(!h) h=1;
	glViewport(0, 0, w, h);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f, w/h, 0.1f, 100.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}
//---------------------------------------------------------------------------
void TFormMain::RenderGLScene()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
	DrawObjects();
	glFlush();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormPaint(TObject *Sender)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glFlush();
	DrawObjects();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormDestroy(TObject *Sender)
{
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(hRC);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormKeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	if(Key == VK_ESCAPE)
		Close();

	if(Key==VK_F1)
	{
		light=!light;
		if(light)
			glEnable(GL_LIGHTING);
		else
			glDisable(GL_LIGHTING);
	}

	if(Key==VK_F2)
	{
		if(++object>5)
			object=0;
	}

	if(Key==VK_PRIOR)
		zoom+=0.1;

	if(Key==VK_NEXT)
		zoom-=0.1;

	if (Key == VK_UP)
		xspeed-=0.5;
	if (Key == VK_DOWN)
		xspeed+=0.5;
	if (Key == VK_LEFT)
		yspeed-=0.5;
	if (Key == VK_RIGHT)
		yspeed+=0.5;
}
//---------------------------------------------------------------------------
void TFormMain::DrawObjects()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And Depth Buffer
	glLoadIdentity();
	glTranslatef(0,0,zoom);

	xrot+=xspeed;
	yrot+=yspeed;
	glRotatef(xrot,1.0,0.0,0.0);
	glRotatef(yrot,0.0,1.0,0.0);

	switch(object)
	{
		case 0:	DrawCube();
				break;
		case 1:	glTranslatef(0.0f,0.0f,-1.5f);
				//(radius,radius,height,subdivisions in h/v direction)
				gluCylinder(quadratic,1.0f,1.0f,3.0f,32,32);
				break;
		case 2: //(inner radius,outer radius,subdivisions)
				gluDisk(quadratic,0.5f,1.5f,32,32);
				break;
		case 3: //(radius,subdivisions)
				gluSphere(quadratic,1.3f,32,32);
				break;
		case 4: Angle+=0.02;
				if(Angle>2*3.14)
					Angle=0;
				glTranslatef(0.0f,0.0f,-1.5f);
				gluCylinder(quadratic,(cos(Angle)+1)/2.0f,(sin(Angle)+1)/2.0f,3.0f,32,32);
				break;
		case 5: part1+=p1;			// Increase Start Angle
				part2+=p2;			// Increase Sweep Angle
				if(part1>359)
				{
					p1=0;			// Stop Increasing Sweep Angle
					p2=1;			// Start Increasing Sweep Angle
					part1=0;
					part2=0;
				}
				if(part2>359)
				{
					p1=1;			// Start Increasing Start Angle
					p2=0;			// Stop Increasing Sweep Angle
				}

				gluPartialDisk(quadratic,0.5f,1.5f,32,32,part1,part2-part1);
				break;
	}
}
//---------------------------------------------------------------------------
void TFormMain::DrawCube()
{
		glBegin(GL_QUADS);					// Start Drawing Quads
		// Front Face
		glNormal3f( 0.0f, 0.0f, 1.0f);		// Normal Facing Forward
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Top Left Of The Texture and Quad
		// Back Face
		glNormal3f( 0.0f, 0.0f,-1.0f);		// Normal Facing Away
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Bottom Left Of The Texture and Quad
		// Top Face
		glNormal3f( 0.0f, 1.0f, 0.0f);		// Normal Facing Up
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		// Bottom Face
		glNormal3f( 0.0f,-1.0f, 0.0f);		// Normal Facing Down
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		// Right face
		glNormal3f( 1.0f, 0.0f, 0.0f);		// Normal Facing Right
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		// Left Face
		glNormal3f(-1.0f, 0.0f, 0.0f);		// Normal Facing Left
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
	glEnd();								// Done Drawing Quads
}
//---------------------------------------------------------------------------
int TFormMain::SetupTextures()
{
	glGenTextures(1, &texture[0]);

	bitmap = new Graphics::TBitmap;
	try
	{
		bitmap->LoadFromFile("texture4.bmp");
	}
	catch (...)
	{
		return FALSE;
	}

	const int size=256;
	GLubyte bits[size][size][3];
	for(int i = 0; i < size; i++)
	{
		for(int j = 0; j < size; j++)
		{
			bits[i][j][0]= (GLbyte)GetRValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][1]= (GLbyte)GetGValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][2]= (GLbyte)GetBValue(bitmap->Canvas->Pixels[i][j]);
		}
	}

	//glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
	glBindTexture(GL_TEXTURE_2D, texture[0]);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, size, size, GL_RGB, GL_UNSIGNED_BYTE, bits);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);

	delete bitmap;
	return TRUE;
}

void TFormMain::SetupLights()
{
	GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[]= { 0.0f, 0.0f, 2.0f, 1.0f };

	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);

	glEnable(GL_LIGHT1);
}
