//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <stdio.h>
#pragma hdrstop

#include "GLmain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;

#define	MAX_PARTICLES	1000	// Number Of Particles To Create

int rainbow=0;					// Rainbow mode on/off
int light=0;					// Lighting on/off

GLfloat xspeed=0, yspeed=0;		// To control tail direction
GLfloat	zoom=-40.0f;			// Depth Into The Screen
GLfloat speed=0.0005f;			// Particles motion speed

GLuint color=0;					// Current Color Selection

// Create A Structure For Particle
typedef struct
{
	bool active;				// Active
	float life;					// Life intensity
	float fade;					// Life fade speed

	float r;					// Red
	float g;					// Green
	float b;					// Blue

	float x;					// X Position
	float y;					// Y Position
	float z;					// Z Position

	float xs;					// X Speed
	float ys;					// Y Speed
	float zs;					// Z Speed

	float xg;					// X Gravity
	float yg;					// Y Gravity
	float zg;					// Z Gravity
}
particles;

particles particle[MAX_PARTICLES];

// Rainbow Of Colors
static GLfloat colors[12][3]={
	{1.0f,0.5f,0.5f},{1.0f,0.75f,0.5f},{1.0f,1.0f,0.5f},{0.75f,1.0f,0.5f},
	{0.5f,1.0f,0.5f},{0.5f,1.0f,0.75f},{0.5f,1.0f,1.0f},{0.5f,0.75f,1.0f},
	{0.5f,0.5f,1.0f},{0.75f,0.5f,1.0f},{1.0f,0.5f,1.0f},{1.0f,0.5f,0.75f}};

//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner)
	: TForm(Owner)
{
	Application->OnIdle = IdleLoop;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::IdleLoop(TObject*, bool& done)
{
	if(FormMain->Active==TRUE)
	{
		done = false;
		RenderGLScene();
		SwapBuffers(hDC);
	}
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormCreate(TObject *Sender)
{
	hDC = GetDC(Handle);
	if(!SetPixelFormatDescriptor(24))
		Close();
	hRC = wglCreateContext(hDC);
	if(hRC == NULL)
		ShowMessage("CreateContext failed.");
	if(wglMakeCurrent(hDC, hRC) == false)
		ShowMessage("MakeCurrent failed.");

	if(!InitGL())
		ShowMessage("GL initialization failed.");
}
//---------------------------------------------------------------------------
int __fastcall TFormMain::SetPixelFormatDescriptor(BYTE bits)
{
	int PixelFormat;

	static	PIXELFORMATDESCRIPTOR pfd=	// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),	// Size Of This Pixel Format Descriptor
		1,								// Version Number
		PFD_DRAW_TO_WINDOW |			// Format Must Support Window
		PFD_SUPPORT_OPENGL |			// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,				// Must Support Double Buffering
		PFD_TYPE_RGBA,					// Request An RGBA Format
		bits,							// Select Our Color Depth
		0, 0, 0, 0, 0, 0,				// Color Bits Ignored
		0,								// No Alpha Buffer
		0,								// Shift Bit Ignored
		0,								// No Accumulation Buffer
		0, 0, 0, 0,						// Accumulation Bits Ignored
		16,								// 16Bit Z-Buffer (Depth Buffer)
		0,								// No Stencil Buffer
		0,								// No Auxiliary Buffer
		PFD_MAIN_PLANE,					// Main Drawing Layer
		0,								// Reserved
		0, 0, 0							// Layer Masks Ignored
	};

	if((PixelFormat=ChoosePixelFormat(hDC, &pfd))==0)
	{
		MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK);
		return FALSE;
	}
	if(!SetPixelFormat(hDC, PixelFormat, &pfd))
	{
		MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK);
		return FALSE;
	}

	return TRUE;
}
//---------------------------------------------------------------------------
int TFormMain::InitGL()
{
	if (!SetupTextures())
		return FALSE;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, texture[0]);

	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);

	//glClearDepth(1.0f);							// Depth Buffer Setup
	//glEnable(GL_DEPTH_TEST);					// Enables Depth Testing
	//glDepthFunc(GL_LEQUAL);						// The Type Of Depth Test To Do

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
	glHint(GL_POINT_SMOOTH_HINT,GL_NICEST);				// Really Nice Point Smoothing

	//SetupLights();

	glEnable(GL_BLEND);							// Enable Blending
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	InitParticles();

	return TRUE;
}
//---------------------------------------------------------------------------
void TFormMain::InitParticles()
{
	for (int i=0;i<MAX_PARTICLES;i++)
	{
		particle[i].active=true;
		particle[i].life=1.0f;
		particle[i].fade=(rand()%100)/1000.0f+0.003f;	//<0.003;0.102>
		particle[i].r=colors[(12*i)/MAX_PARTICLES][0];
		particle[i].g=colors[(12*i)/MAX_PARTICLES][1];
		particle[i].b=colors[(12*i)/MAX_PARTICLES][2];
		particle[i].xs=((rand()%50)-26.0f)*10.0f;		//<-260;230>
		particle[i].ys=((rand()%50)-25.0f)*10.0f;		//<-250;240>
		particle[i].zs=((rand()%50)-25.0f)*10.0f;
		particle[i].xg=0.0f;
		particle[i].yg=-0.8f;
		particle[i].zg=0.0f;
	}
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormResize(TObject *Sender)
{
	GLfloat w = ClientWidth;
	GLfloat h = ClientHeight;

	if(!h) h=1;
	glViewport(0, 0, w, h);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f, w/h, 0.1f, 200.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}
//---------------------------------------------------------------------------
void TFormMain::RenderGLScene()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
	DrawObjects();
	glFlush();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormPaint(TObject *Sender)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glFlush();
	DrawObjects();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormDestroy(TObject *Sender)
{
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(hRC);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormKeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	if(Key == VK_ESCAPE)
		Close();

	//zoom in/out
	if(Key==VK_PRIOR)
		zoom+=0.1;

	if(Key==VK_NEXT)
		zoom-=0.1;

	//gravity control
	if (Key==VK_NUMPAD8)
	{
		for(int i=0;i<MAX_PARTICLES;i++)
		{
			if(particle[i].yg<1.5f)
				particle[i].yg+=0.01f;
		}
	}

	if (Key==VK_NUMPAD2)
	{
		for(int i=0;i<MAX_PARTICLES;i++)
		{
			if(particle[i].yg>-1.5f)
				particle[i].yg-=0.01f;
		}
	}

	if (Key==VK_NUMPAD6)
	{
		for(int i=0;i<MAX_PARTICLES;i++)
		{
			if(particle[i].xg<1.5f)
				particle[i].xg+=0.01f;
		}
	}

	if (Key==VK_NUMPAD4)
	{
		for(int i=0;i<MAX_PARTICLES;i++)
		{
			if(particle[i].xg>-1.5f)
				particle[i].xg-=0.01f;
		}
	}

	//explode from center
	if (Key==VK_NUMPAD5)
	{
		for(int i=0;i<MAX_PARTICLES;i++)
		{
			//move to the screen center
			particle[i].x=0.0f;
			particle[i].y=0.0f;
			particle[i].z=0.0f;
			//apply speed (high) and direction
			particle[i].xs=((rand()%50)-26.0f)*10.0f;
			particle[i].ys=((rand()%50)-25.0f)*10.0f;
			particle[i].zs=((rand()%50)-25.0f)*10.0f;
		}
	}

	//speed up/down particles
	if(Key==VK_ADD)
	{
		if(speed<0.001f)
			speed+=0.00001f;
	}

	if(Key==VK_SUBTRACT)
	{
		if(speed>0.00025f)
			speed-=0.00001f;
	}

	//rainbow mode on/off
	if(Key==VK_F1)
		rainbow=!rainbow;

	//speed up/down particles
	if (Key == VK_UP)
	{
		if(xspeed<200.0)
			yspeed+=5;
	}
	if (Key == VK_DOWN)
	{
		if(xspeed>-200.0)
			yspeed-=5;
	}
	if (Key == VK_LEFT)
	{
		if(xspeed>-200.0)
			xspeed-=5;
	}
	if (Key == VK_RIGHT)
	{
		if(xspeed<200.0)
			xspeed+=5;
	}
}
//---------------------------------------------------------------------------
void TFormMain::DrawObjects()
{
	float x,y,z;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And Depth Buffer

	for(int i=0;i<MAX_PARTICLES;i++)
	{
		if(particle[i].active)
		{
			x=particle[i].x;
			y=particle[i].y;
			z=particle[i].z+zoom;
			glColor4f(particle[i].r,particle[i].g,particle[i].b,particle[i].life);
			//draw a QUAD (using 2 traingles for speed up rendering)
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+0.5f,y+0.5f,z); // Top Right
				glTexCoord2d(0,1); glVertex3f(x-0.5f,y+0.5f,z); // Top Left
				glTexCoord2d(1,0); glVertex3f(x+0.5f,y-0.5f,z); // Bottom Right
				glTexCoord2d(0,0); glVertex3f(x-0.5f,y-0.5f,z); // Bottom Left
			glEnd();
			//apply direction and speed
			particle[i].x+=particle[i].xs*speed;
			particle[i].y+=particle[i].ys*speed;
			particle[i].z+=particle[i].zs*speed;
			//apply gravity
			particle[i].xs+=particle[i].xg;
			particle[i].ys+=particle[i].yg;
			particle[i].zs+=particle[i].zg;
			//reduce life
			particle[i].life-=particle[i].fade;
			//is particle run out off life
			if (particle[i].life<0.0f)
			{
				//rejuvenate
				particle[i].life=1.0f;
				particle[i].fade=(rand()%100)/1000.0f+0.003f;
				//start in the center of the screen
				particle[i].x=0.0f;
				particle[i].y=0.0f;
				particle[i].z=0.0f;
				//new speed (low) and direction (user controllable)
				particle[i].xs=xspeed+(rand()%60)-32.0f;
				particle[i].ys=yspeed+(rand()%60)-30.0f;
				particle[i].zs=(rand()%60)-30.0f;
				//apply color (according to "color" variable)
				particle[i].r=colors[color][0];
				particle[i].g=colors[color][1];
				particle[i].b=colors[color][2];
			}
		}
	}
}
//---------------------------------------------------------------------------
int TFormMain::SetupTextures()
{
	glGenTextures(1, &texture[0]);

	bitmap = new Graphics::TBitmap;
	try
	{
		bitmap->LoadFromFile("particle.bmp");
	}
	catch (...)
	{
		return FALSE;
	}

	const int size=64;
	GLubyte bits[size][size][3];
	for(int i = 0; i < size; i++)
	{
		for(int j = 0; j < size; j++)
		{
			bits[i][j][0]= (GLbyte)GetRValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][1]= (GLbyte)GetGValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][2]= (GLbyte)GetBValue(bitmap->Canvas->Pixels[i][j]);
		}
	}

	glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
	glBindTexture(GL_TEXTURE_2D, texture[0]);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, size, size, 0, GL_RGB, GL_UNSIGNED_BYTE, bits);
	//gluBuild2DMipmaps(GL_TEXTURE_2D, 3, size, size, GL_RGB, GL_UNSIGNED_BYTE, bits);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	delete bitmap;
	return TRUE;
}

void TFormMain::SetupLights()
{
	GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[]= { 0.0f, 0.0f, 2.0f, 1.0f };

	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);

	glEnable(GL_LIGHT1);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::Timer1Timer(TObject *Sender)
{
	if(rainbow)
	{
		if(++color>11)
			color=0;
	}
}


