//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <stdio.h>
#pragma hdrstop

#include "GLmain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;

GLuint	base;				// Base Display List For The Font Set
GLYPHMETRICSFLOAT gmf[256];	// Storage For Information About Our Font
GLfloat	rot;    			// Rotation Angle

int MaterialFlag=0;
int ColorFlag=0;

//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner)
	: TForm(Owner)
{
	Application->OnIdle = IdleLoop;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::IdleLoop(TObject*, bool& done)
{
	if(FormMain->Active==TRUE)
	{
		done = false;
		RenderGLScene();
		SwapBuffers(hDC);
	}
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormCreate(TObject *Sender)
{
	hDC = GetDC(Handle);
	if(!SetPixelFormatDescriptor(24))
		Close();
	hRC = wglCreateContext(hDC);
	if(hRC == NULL)
		ShowMessage("CreateContext failed.");
	if(wglMakeCurrent(hDC, hRC) == false)
		ShowMessage("MakeCurrent failed.");

    if(!InitGL())
		ShowMessage("GL initialization failed.");
}
//---------------------------------------------------------------------------
int __fastcall TFormMain::SetPixelFormatDescriptor(BYTE bits)
{
	int PixelFormat;

	static	PIXELFORMATDESCRIPTOR pfd=	// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),	// Size Of This Pixel Format Descriptor
		1,								// Version Number
		PFD_DRAW_TO_WINDOW |			// Format Must Support Window
		PFD_SUPPORT_OPENGL |			// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,				// Must Support Double Buffering
		PFD_TYPE_RGBA,					// Request An RGBA Format
		bits,							// Select Our Color Depth
		0, 0, 0, 0, 0, 0,				// Color Bits Ignored
		0,								// No Alpha Buffer
		0,								// Shift Bit Ignored
		0,								// No Accumulation Buffer
		0, 0, 0, 0,						// Accumulation Bits Ignored
		16,								// 16Bit Z-Buffer (Depth Buffer)
		0,								// No Stencil Buffer
		0,								// No Auxiliary Buffer
		PFD_MAIN_PLANE,					// Main Drawing Layer
		0,								// Reserved
		0, 0, 0							// Layer Masks Ignored
	};

	if((PixelFormat=ChoosePixelFormat(hDC, &pfd))==0)
	{
		MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK);
		return FALSE;
	}
	if(!SetPixelFormat(hDC, PixelFormat, &pfd))
	{
		MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK);
		return FALSE;
	}

	return TRUE;
}
//---------------------------------------------------------------------------
int TFormMain::InitGL()
{
	if (!SetupTextures())
		return FALSE;

	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

	glClearDepth(1.0f);							// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);					// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);						// The Type Of Depth Test To Do

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations

	SetupLights();
	glEnable(GL_LIGHTING);

	BuildFont();

	return TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormResize(TObject *Sender)
{
	GLfloat w = ClientWidth;
	GLfloat h = ClientHeight;

	if(!h) h=1;
	glViewport(0, 0, w, h);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f, w/h, 0.1f, 100.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}
//---------------------------------------------------------------------------
void TFormMain::RenderGLScene()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
	DrawObjects();
	glFlush();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormPaint(TObject *Sender)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glFlush();
	DrawObjects();
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormDestroy(TObject *Sender)
{
	glDeleteLists(base, 96);
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(hRC);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormKeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	if(Key == VK_ESCAPE)
		Close();

	if(Key==VK_F1)
	{
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, texture[0]);
		// Texturing Contour Anchored To The Eye
		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
		// Auto Texture Generation
		glEnable(GL_TEXTURE_GEN_S);
		glEnable(GL_TEXTURE_GEN_T);
	}

	if(Key==VK_F2)
	{
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, texture[1]);
		// Texturing Contour Anchored To The Sphere Around The Scene
		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		// Auto Texture Generation
		glEnable(GL_TEXTURE_GEN_S);
		glEnable(GL_TEXTURE_GEN_T);
	}

	if(Key==VK_F3)
		glDisable(GL_TEXTURE_2D);

	if(Key==VK_F4)
	{
		if(!MaterialFlag)
		{
			glEnable(GL_COLOR_MATERIAL);
			MaterialFlag=1;
		}
		else
		{
			glDisable(GL_COLOR_MATERIAL);
			MaterialFlag=0;
		}
	}

	if(Key==VK_F5)
	{
		if(!ColorFlag)
			ColorFlag=1;
		else
			ColorFlag=0;
	}

	/*
	if (Key == VK_UP)
		xrot-=0.5;
	if (Key == VK_DOWN)
		xrot+=0.5;
	if (Key == VK_LEFT)
		yrot-=0.5;
	if (Key == VK_RIGHT)
	yrot+=0.5;
	*/
}
//---------------------------------------------------------------------------
void TFormMain::DrawObjects()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And Depth Buffer
	glLoadIdentity();

	glTranslatef(0,0,-1.5);

	glRotatef(rot,1.0f,0.0f,0.0f);				// Rotate On The X Axis
	glRotatef(rot*1.2f,0.0f,1.0f,0.0f);			// Rotate On The Y Axis
	glRotatef(rot*1.4f,0.0f,0.0f,1.0f);

	// Pulsing Colors Based On The Rotation
	if(ColorFlag)
		glColor3f(1.0f*float(cos(rot/20.0f)),1.0f*float(sin(rot/25.0f)),1.0f-0.5f*float(cos(rot/17.0f)));

	glTranslatef(-0.3,-0.3,0);

	DrawText("N");

	rot+=0.1f;
}
//---------------------------------------------------------------------------
void TFormMain::DrawText(char* Text)
{
	GLfloat l=0;

	for (unsigned int loop=0;loop<strlen(Text);loop++)	// Loop To Find Text Length
	{
		l+=gmf[Text[loop]].gmfCellIncX;		// Increase Length By Each Characters Width
	}

	glTranslatef((int(-l))/2.0,0.0f,0.0f);

	glPushAttrib(GL_LIST_BIT);
	glListBase(base - 32);
	glCallLists(strlen(Text), GL_UNSIGNED_BYTE, Text);
	glPopAttrib();
}
//---------------------------------------------------------------------------
int TFormMain::SetupTextures()
{
	glGenTextures(2, &texture[0]);

	bitmap = new Graphics::TBitmap;
	try
	{
		bitmap->LoadFromFile("texture3.bmp");
	}
	catch (...)
	{
		return FALSE;
	}

	const int size=256;
	GLubyte bits[size][size][3];
	for(int i = 0; i < size; i++)
	{
		for(int j = 0; j < size; j++)
		{
			bits[i][j][0]= (GLbyte)GetRValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][1]= (GLbyte)GetGValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][2]= (GLbyte)GetBValue(bitmap->Canvas->Pixels[i][j]);
		}
	}

	//glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
	glBindTexture(GL_TEXTURE_2D, texture[0]);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, size, size, GL_RGB, GL_UNSIGNED_BYTE, bits);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);

	try
	{
		bitmap->LoadFromFile("texture22.bmp");
	}
	catch (...)
	{
		return FALSE;
	}

	for(int i = 0; i < size; i++)
	{
		for(int j = 0; j < size; j++)
		{
			bits[i][j][0]= (GLbyte)GetRValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][1]= (GLbyte)GetGValue(bitmap->Canvas->Pixels[i][j]);
			bits[i][j][2]= (GLbyte)GetBValue(bitmap->Canvas->Pixels[i][j]);
		}
	}

	//glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
	glBindTexture(GL_TEXTURE_2D, texture[1]);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, size, size, GL_RGB, GL_UNSIGNED_BYTE, bits);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);

	delete bitmap;

	return TRUE;
}

void TFormMain::SetupLights()
{
	GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[]= { 0.0f, 0.0f, 2.0f, 1.0f };

	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);

	glEnable(GL_LIGHT1);
}

void TFormMain::BuildFont()
{
	HFONT font;								// Windows Font ID

	base = glGenLists(96);
	font = CreateFont( 	-24,				// Height Of Font
				0,							// Width Of Font
				0,							// Angle Of Escapement
				0,							// Orientation Angle
				FW_BOLD,					// Font Weight
				FALSE,						// Italic
				FALSE,						// Underline
				FALSE,						// Strikeout
				SYMBOL_CHARSET,				// Character Set Identifier
				OUT_TT_PRECIS,				// Output Precision
				CLIP_DEFAULT_PRECIS,		// Clipping Precision
				ANTIALIASED_QUALITY,		// Output Quality
				FF_DONTCARE|DEFAULT_PITCH,	// Family And Pitch
				"Wingdings");				// Font Name

	SelectObject(hDC, font);				// Selects The Font We Want
	wglUseFontOutlines(	hDC,				// Select The Current DC
						32,					// Starting Character
						96,					// Number Of Display Lists To Build
						base,				// Starting Display Lists
						0.1f,				// Deviation From The True Outlines
						0.2f,				// Font Thickness In The Z Direction
						WGL_FONT_POLYGONS,	// Use Polygons, Not Lines
						gmf);				// Address Of Buffer To Recieve Data

}
