#include "Linia.h"

CLinia::CLinia(): licznik(0),Full(false)
{
	TabKostek = new CKostka[W];
}

CLinia::~CLinia()
{
	delete[] TabKostek;
}

void CLinia::Ustaw(int y)
{
	for (int i=0;i<W;i++)
		TabKostek[i].Ustaw(i,y);
}

void CLinia::UsunLinie()
{
	for(int i=0;i<W;i++)
		TabKostek[i].Usun();;
	licznik=0;
	Full=false;
}

void CLinia::UstawKostke(int x,int kolor)
{
	TabKostek[x].ZmienKolor(kolor);
	if (++licznik == W)
		Full=true;
}

void CLinia::UsunKostke(int x)
{
	TabKostek[x].Usun();
	licznik--;
	Full=false;
}

bool CLinia::Visible(int x)
{
	if (x>=W)
    	return(true);
    else
    	return(TabKostek[x].Visible);
}

CLinia& CLinia:: operator= (const CLinia &L)
{
    for(int i=0;i<W;i++)
    	this->TabKostek[i]=L.TabKostek[i];
    this->Full=L.Full;
    this->licznik=L.licznik;
    return(*this);
}

void CLinia::Rysuj()
{
	if(licznik)
	{
		for(int i=0;i<W;i++)
		{
			if(TabKostek[i].Visible)
				TabKostek[i].Rysuj();
		}
	}
}

void CLinia::Flash(int kolor)
{
	for(int i=0;i<W;i++)
    {
		TabKostek[i].ZmienKolor(kolor);
        //wait some time
    }
}
