#include <windows.h>
#include <gl/gl.h>

#include "Kostka.h"

void CKostka::Ustaw(int a,int b)
{
	GLfloat Ambient[]={ 0.6, 0.6, 0.6, 0.4 };
	GLfloat Specular[]={ 0.8, 0.8, 0.8, 0.8 };
	GLfloat Shininess=60.0;

	x=a; y=b;

	cube=glGenLists(1);
	GLfloat size=2.2f/H;
	GLfloat scale=size/2.0f;

	glNewList(cube,GL_COMPILE);
		glMaterialfv(GL_FRONT,GL_AMBIENT,Ambient);
		glMaterialfv(GL_FRONT,GL_SPECULAR,Specular);
		glMaterialf(GL_FRONT,GL_SHININESS,Shininess);

		glLoadIdentity();
		glTranslatef(1.8*x*size-1.0f,y*size-1.0f,-2.4f);
		glScalef(1.8*scale,scale,scale);

		glBegin(GL_QUADS);
			// Front
			glNormal3f( 0.0f, 0.0f, 1.0f);
			glVertex3f(-1.0f, -1.0f,  1.0f);
			glVertex3f( 1.0f, -1.0f,  1.0f);
			glVertex3f( 1.0f,  1.0f,  1.0f);
			glVertex3f(-1.0f,  1.0f,  1.0f);
			// Back
			glNormal3f( 0.0f, 0.0f, -1.0f);
			glVertex3f(-1.0f, -1.0f, -1.0f);
			glVertex3f(-1.0f,  1.0f, -1.0f);
			glVertex3f( 1.0f,  1.0f, -1.0f);
			glVertex3f( 1.0f, -1.0f, -1.0f);
			// Top
			glNormal3f( 0.0f, 1.0f, 0.0f);
			glVertex3f(-1.0f,  1.0f, -1.0f);
			glVertex3f(-1.0f,  1.0f,  1.0f);
			glVertex3f( 1.0f,  1.0f,  1.0f);
			glVertex3f( 1.0f,  1.0f, -1.0f);
			// Bottom
			glNormal3f( 0.0f, -1.0f, 0.0f);
			glVertex3f(-1.0f, -1.0f, -1.0f);
			glVertex3f( 1.0f, -1.0f, -1.0f);
			glVertex3f( 1.0f, -1.0f,  1.0f);
			glVertex3f(-1.0f, -1.0f,  1.0f);
			// Right
			glNormal3f( 1.0f, 0.0f, 0.0f);
			glVertex3f( 1.0f, -1.0f, -1.0f);
			glVertex3f( 1.0f,  1.0f, -1.0f);
			glVertex3f( 1.0f,  1.0f,  1.0f);
			glVertex3f( 1.0f, -1.0f,  1.0f);
			// Left
			glNormal3f( -1.0f, 0.0f, 0.0f);
			glVertex3f(-1.0f, -1.0f, -1.0f);
			glVertex3f(-1.0f, -1.0f,  1.0f);
			glVertex3f(-1.0f,  1.0f,  1.0f);
			glVertex3f(-1.0f,  1.0f, -1.0f);
		glEnd();
	glEndList();
}

void CKostka::ZmienKolor(int kolor)
{
	this->kolor=kolor;
	Visible=true;
}

CKostka& CKostka:: operator= (const CKostka &K)
{
	if (K.Visible)
		this->ZmienKolor(K.kolor);
	else
		this->Visible=false;

	return(*this);
}

void CKostka::Usun()
{
	Visible=false;
}

void CKostka::Rysuj()
{
	static GLfloat CubeColors[7][4]=	//colors definition
	{	//Red, Sky-Blue, Orange, Green, Yellow, Violet, Blue
		{1.0f,0.0f,0.0f,0.5f},{0.0f,1.0f,1.0f,0.5f},{1.0f,0.5f,0.0f,0.5f},
		{0.0f,1.0f,0.0f,0.5f},{1.0f,1.0f,0.0f,0.5f},{1.0f,0.0f,1.0f,0.5f},
		{0.0f,0.0f,1.0f,0.5f}
	};

	glMaterialfv(GL_FRONT,GL_DIFFUSE,CubeColors[kolor]);
	glCallList(cube);
}
