#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <ExtCtrls.hpp>

#include <gl\gl.h>
#include <gl\glu.h>

#include "Klocek.h"
#include "Czas.h"

//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:
	TMainMenu *MainMenu1;
	TMenuItem *Game;
	TMenuItem *Go;
	TMenuItem *Exit;
	TMenuItem *Level;
	TMenuItem *N11;
	TMenuItem *N21;
	TMenuItem *N31;
	TMenuItem *N41;
	TMenuItem *N51;
	TMenuItem *N61;
	TMenuItem *N71;
	TMenuItem *N81;
	TMenuItem *N91;
	TMenuItem *N101;
	TMenuItem *Help;
	TMenuItem *Info;
	TMenuItem *About;
	TTimer *Start;
	TTimer *Move;
	TMenuItem *Options;
	TMenuItem *Blend;
	TMenuItem *Falling;
	void __fastcall N11Click(TObject *Sender);
	void __fastcall N21Click(TObject *Sender);
	void __fastcall N31Click(TObject *Sender);
	void __fastcall N41Click(TObject *Sender);
	void __fastcall N51Click(TObject *Sender);
	void __fastcall N61Click(TObject *Sender);
	void __fastcall N71Click(TObject *Sender);
	void __fastcall N81Click(TObject *Sender);
	void __fastcall N91Click(TObject *Sender);
	void __fastcall N101Click(TObject *Sender);
	void __fastcall ExitClick(TObject *Sender);
	void __fastcall AboutClick(TObject *Sender);
	void __fastcall InfoClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall GoClick(TObject *Sender);
	void __fastcall StartTimer(TObject *Sender);
	void __fastcall FormKeyDown(TObject *Sender,WORD &Key,TShiftState Shift);
	void __fastcall MoveTimer(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall FormPaint(TObject *Sender);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall BlendClick(TObject *Sender);
	void __fastcall FormKeyUp(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall FallingClick(TObject *Sender);
private:
	HDC hDC;
	HGLRC hRC;

	GLuint base;				//display list for fonts
	GLYPHMETRICSFLOAT gmf[256]; //font info storing structure

	GLuint logo, start, end, bonus;	//display lists for text
	GLuint border;				//map border display list
	GLuint BlockType;			//display list for block types

	GLfloat RotAngle;			//rotation angle for animations
    CZegar Zegar;               //real-time timer

	CPlansza* Plansza;			//map object
	CKlocek* X;					//new block
	CKlocek* ActiveList[60];    //list of active blocks
	int ActiveListPointer;
	int NextBlock;				//type of the next block
	int KeyPressed;				//to avoid accidental block falling
public:
	 __fastcall TForm1(TComponent* Owner);
	 __fastcall void IdleLoopLogo(TObject*, bool&);
	 __fastcall void IdleLoopEnd(TObject*, bool&);
	 __fastcall void IdleLoopPlay(TObject*, bool&);

	int __fastcall SetPixelFormatDescriptor(BYTE);
	int InitGL();
	void SetupLights();
	void SetupLists();
	void SetupCubeList();
	void BuildFont();
	void DrawText(char*);
	void RenderGLScene();
	void DrawScore();
	void DrawNextBlock();
	void StartAnim();
	void BonusAnim(int);

	void SetLevel(int);
	CKlocek *LosujKlocek();
	void Graj();
	int Polozony(int);
};

//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------

