//---------------------------------------------------------------------------

#include <vcl.h>
#include <math.h>
#include <stdio.h>
#pragma hdrstop

#include "Dialogs.hpp"

#include "Form.h"
#include "About.h"
#include "Help.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

GLfloat c2,e2,x2,y2;
long int Suma=0,Liczba=0;

TForm1 *Form1;

__fastcall TForm1::TForm1(TComponent* Owner):TForm(Owner)
{
	RotAngle=0;
	KeyPressed=0;
	NextBlock=rand()%5+1;

	Application->OnIdle = IdleLoopLogo;
    Zegar.OdczytajCzas();
}


//openGL window service methodes
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
 //preparing openGL window
 hDC = GetDC(Handle);
 if(!SetPixelFormatDescriptor(24))
	Close();
 hRC = wglCreateContext(hDC);
 if(hRC == NULL)
	ShowMessage("Could not CreateContext.");
 if(wglMakeCurrent(hDC, hRC) == false)
	ShowMessage("Could not MakeCurrent.");

 if(!InitGL())
	ShowMessage("GL initialization failed.");

 //creating tetris play map
 Plansza = new CPlansza();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
	if(Plansza->Run)
	{
		delete X;
		for(int i=0;i<ActiveListPointer;i++)
			delete ActiveList[i];
	}
	delete Plansza;
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(hRC);
}
//---------------------------------------------------------------------------
int __fastcall TForm1::SetPixelFormatDescriptor(BYTE bits)
{
	int PixelFormat;

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};

	if((PixelFormat=ChoosePixelFormat(hDC, &pfd))==0)
	{
		MessageBox(NULL, "ChoosePixelFormat failed.", "Error", MB_OK);
		return FALSE;
	}
	if(!SetPixelFormat(hDC, PixelFormat, &pfd))
	{
		MessageBox(NULL, "SetPixelFormat failed.", "Error", MB_OK);
		return FALSE;
	}

	return TRUE;
}
//---------------------------------------------------------------------------
int TForm1::InitGL()
{
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBlendFunc(GL_ONE, GL_ONE);
	glClearDepth(1.0f);

	SetupLights();
	glEnable(GL_LIGHTING);

	BuildFont();
	SetupLists();

	glEnable(GL_DEPTH_TEST);

	return TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormResize(TObject *Sender)
{
	GLfloat w = ClientWidth;
	GLfloat h = ClientHeight;

	if(!h) h=1;
	glViewport(0, 0, w, h);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-1.0f, 2.0f, -1.0f, 1.0f, 2.0f, 20.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}
//---------------------------------------------------------------------------
void TForm1::RenderGLScene()
{
	DrawScore();
	DrawNextBlock();
	glCallList(border);

	if(Blend->Checked)
	{
		glDisable(GL_DEPTH_TEST);
		glEnable(GL_BLEND);
	}

	glEnable(GL_LIGHT1);
	Plansza->Rysuj();
	glDisable(GL_LIGHT1);

	if(Blend->Checked)
	{
		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	SwapBuffers(hDC);
}
//---------------------------------------------------------------------------
void TForm1::DrawText(char* Text)
{
	glPushAttrib(GL_LIST_BIT);
	glListBase(base-32);
	glCallLists(strlen(Text), GL_UNSIGNED_BYTE, Text);
	glPopAttrib();
}
//---------------------------------------------------------------------------
void TForm1::SetupLights()
{
	GLfloat Ambient[]={ 0.2f, 0.2f, 0.2f, 1.0f };
	GLfloat Diffuse[]={ 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat Specular[]={ 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat SpotDirection[]={ 0.0, 0.0, -1.0 };
	GLfloat Position[]={ 0.0f, 0.0f, 0.0f, 1.0f };
	GLfloat Position2[]={ 2.5f, -0.1f, 0.0f, 1.0f };
	GLfloat Position3[]={ 2.7f, 1.0f, 0.0f, 1.0f };

	glLightfv(GL_LIGHT1, GL_AMBIENT, Ambient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, Diffuse);
	glLightfv(GL_LIGHT1, GL_SPECULAR, Specular);
	glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, SpotDirection);
	glLightfv(GL_LIGHT1, GL_POSITION, Position);
	glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, 40.0f);
	glLightf(GL_LIGHT1, GL_SPOT_EXPONENT, 35.0f);

	glLightfv(GL_LIGHT2, GL_AMBIENT, Ambient);
	glLightfv(GL_LIGHT2, GL_DIFFUSE, Diffuse);
	glLightfv(GL_LIGHT2, GL_SPECULAR, Specular);
	glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, SpotDirection);
	glLightfv(GL_LIGHT2, GL_POSITION, Position2);
	glLightf(GL_LIGHT2, GL_SPOT_CUTOFF, 50.0f);
	glLightf(GL_LIGHT2, GL_SPOT_EXPONENT, 50.0f);

	glLightfv(GL_LIGHT3, GL_AMBIENT, Ambient);
	glLightfv(GL_LIGHT3, GL_DIFFUSE, Diffuse);
	glLightfv(GL_LIGHT3, GL_SPECULAR, Specular);
	glLightfv(GL_LIGHT3, GL_SPOT_DIRECTION, SpotDirection);
	glLightfv(GL_LIGHT3, GL_POSITION, Position3);
	glLightf(GL_LIGHT3, GL_SPOT_CUTOFF, 50.0f);
	glLightf(GL_LIGHT3, GL_SPOT_EXPONENT, 80.0f);
}
//---------------------------------------------------------------------------
void TForm1::SetupLists()
{
	logo=glGenLists(1);
	start=glGenLists(1);
	end=glGenLists(1);
	bonus=glGenLists(1);

	GLfloat const size=2.2/H;

	glNewList(logo,GL_COMPILE);
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_COLOR_MATERIAL);
		glDisable(GL_BLEND);
		glEnable(GL_LIGHT0);
		glColor3f(0.0f,0.7f,1.0f);
		glTranslatef(-3.1f,0.0f,0.0f);
		glRotatef(20.0f,1.0f,0.0f,0.0f);
		DrawText("MoMaT's Tetris");
		glDisable(GL_COLOR_MATERIAL);
		glDisable(GL_LIGHT0);
	glEndList();

	glNewList(start,GL_COMPILE);
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_COLOR_MATERIAL);
		glDisable(GL_BLEND);
		glEnable(GL_LIGHT0);
		glColor3f(0.7f,0.7f,0.0f);
		glRotatef(-20.0f,1.0f,0.0f,0.0f);
		DrawText("START");
		glDisable(GL_COLOR_MATERIAL);
		glDisable(GL_LIGHT0);
	glEndList();

	glNewList(end,GL_COMPILE);
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_COLOR_MATERIAL);
		glDisable(GL_BLEND);
		glEnable(GL_LIGHT0);
		glColor3f(1.0f,0.0f,0.5f);
		glRotatef(-20.0,1.0,0.0,0.0);
		DrawText("GAME OVER");
	glEndList();

	GLfloat Ambient[]={ 0.6, 0.6, 0.6, 0.4 };
	GLfloat Specular[]={ 1.0, 1.0, 1.0, 1.0 };
	GLfloat Diffuse[]={ 1.0f, 0.75f, 0.0f, 0.5f};
	GLfloat Shininess=60.0;

	glNewList(bonus,GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_AMBIENT, Ambient);
		glMaterialfv(GL_FRONT, GL_SPECULAR, Specular);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, Diffuse);
		glMaterialf(GL_FRONT, GL_SHININESS, Shininess);
		glEnable(GL_LIGHT1);
		glEnable(GL_LIGHT2);
		glEnable(GL_LIGHT3);
		glScalef(0.5f, 0.5f, 0.5f);
		glTranslatef(-1.5f, 0.0f, 0.0f);
		DrawText("BONUS");
		glDisable(GL_LIGHT1);
		glDisable(GL_LIGHT2);
		glDisable(GL_LIGHT3);
	glEndList();

	border=glGenLists(1);
	glNewList(border,GL_COMPILE);
		glEnable(GL_COLOR_MATERIAL);
		glLoadIdentity();
		glTranslatef(0.0,0.0,-2.5);
		glColor3f(2.0,0.0,0.0);
		glBegin(GL_LINES);
			glVertex3f(1.8*(W-1)*size-0.8f,-1.12f,0.0f);
			glVertex3f(1.8*(W-1)*size-0.8f,(H-1)*size-0.87f,0.0f);
			glVertex3f(-1.2f,(H-1)*size-0.87f,0.0f);
			glVertex3f(-1.2f,-1.12f,0.0f);
		glEnd();
		glDisable(GL_COLOR_MATERIAL);
	glEndList();

	BlockType=glGenLists(7);

	GLfloat BlockAmbient[]={ 0.5, 0.5, 0.5, 0.5 };
	GLfloat BlockSpecular[]={ 1.0, 0.0, 0.0, 1.0 };

	glNewList(BlockType,GL_COMPILE);		//1 - I
		glMaterialfv(GL_FRONT,GL_AMBIENT,BlockAmbient);
		glMaterialfv(GL_FRONT,GL_SPECULAR,BlockSpecular);
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glBegin(GL_QUADS);
			//Front
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-1.0f, -4.0f, 1.0f);
			glVertex3f(-1.0f,  4.0f, 1.0f);
			glVertex3f( 1.0f,  4.0f, 1.0f);
			glVertex3f( 1.0f, -4.0f, 1.0f);
			//Back
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f, -4.0f, -1.0f);
			glVertex3f(-1.0f,  4.0f, -1.0f);
			glVertex3f( 1.0f,  4.0f, -1.0f);
			glVertex3f( 1.0f, -4.0f, -1.0f);
			//Top
			glNormal3f( 0.0f,  1.0f,  0.0f);
			glVertex3f(-1.0f,  4.0f,  1.0f);
			glVertex3f(-1.0f,  4.0f, -1.0f);
			glVertex3f( 1.0f,  4.0f, -1.0f);
			glVertex3f( 1.0f,  4.0f,  1.0f);
			//Bottom
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f(-1.0f, -4.0f,  1.0f);
			glVertex3f(-1.0f, -4.0f, -1.0f);
			glVertex3f( 1.0f, -4.0f, -1.0f);
			glVertex3f( 1.0f, -4.0f,  1.0f);
			//Left
			glNormal3f(-1.0f,  0.0f,  0.0f);
			glVertex3f(-1.0f, -4.0f,  1.0f);
			glVertex3f(-1.0f, -4.0f, -1.0f);
			glVertex3f(-1.0f,  4.0f, -1.0f);
			glVertex3f(-1.0f,  4.0f,  1.0f);
			//Right
			glNormal3f( 1.0f,  0.0f,  0.0f);
			glVertex3f( 1.0f, -4.0f,  1.0f);
			glVertex3f( 1.0f, -4.0f, -1.0f);
			glVertex3f( 1.0f,  4.0f, -1.0f);
			glVertex3f( 1.0f,  4.0f,  1.0f);
		glEnd();
	glEndList();

	glNewList(BlockType+1,GL_COMPILE);		//2 - L
		glMaterialfv(GL_FRONT,GL_AMBIENT,BlockAmbient);
		glMaterialfv(GL_FRONT,GL_SPECULAR,BlockSpecular);
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glBegin(GL_POLYGON);
			//Front
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-2.0f, -3.0f, 1.0f);
			glVertex3f(-2.0f,  3.0f, 1.0f);
			glVertex3f( 0.0f,  3.0f, 1.0f);
			glVertex3f( 0.0f, -1.0f, 1.0f);
			glVertex3f( 2.0f, -1.0f, 1.0f);
			glVertex3f( 2.0f, -3.0f, 1.0f);
		glEnd();
		glBegin(GL_POLYGON);
			//Back
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-2.0f, -3.0f, -1.0f);
			glVertex3f(-2.0f,  3.0f, -1.0f);
			glVertex3f( 0.0f,  3.0f, -1.0f);
			glVertex3f( 0.0f, -1.0f, -1.0f);
			glVertex3f( 2.0f, -1.0f, -1.0f);
			glVertex3f( 2.0f, -3.0f, -1.0f);
		glEnd();
		glBegin(GL_QUADS);
			//TopA
			glNormal3f( 0.0f,  1.0f, 0.0f);
			glVertex3f(-2.0f,  3.0f,  1.0f);
			glVertex3f(-2.0f,  3.0f, -1.0f);
			glVertex3f( 0.0f,  3.0f, -1.0f);
			glVertex3f( 0.0f,  3.0f,  1.0f);
			//TopB
			glNormal3f( 0.0f,  1.0f, 0.0f);
			glVertex3f( 0.0f, -1.0f,  1.0f);
			glVertex3f( 0.0f, -1.0f, -1.0f);
			glVertex3f( 2.0f, -1.0f, -1.0f);
			glVertex3f( 2.0f, -1.0f,  1.0f);
			//Bottom
			glNormal3f( 0.0f, -1.0f, 0.0f);
			glVertex3f(-2.0f, -3.0f,  1.0f);
			glVertex3f(-2.0f, -3.0f, -1.0f);
			glVertex3f( 2.0f, -3.0f, -1.0f);
			glVertex3f( 2.0f, -3.0f,  1.0f);
			//Left
			glNormal3f(-1.0f,  0.0f, 0.0f);
			glVertex3f(-2.0f, -3.0f,  1.0f);
			glVertex3f(-2.0f, -3.0f, -1.0f);
			glVertex3f(-2.0f,  3.0f, -1.0f);
			glVertex3f(-2.0f,  3.0f,  1.0f);
			//RightA
			glNormal3f( 1.0f,  0.0f, 0.0f);
			glVertex3f( 0.0f, -1.0f,  1.0f);
			glVertex3f( 0.0f, -1.0f, -1.0f);
			glVertex3f( 0.0f,  3.0f, -1.0f);
			glVertex3f( 0.0f,  3.0f,  1.0f);
			//RightB
			glNormal3f( 1.0f,  0.0f, 0.0f);
			glVertex3f( 2.0f, -3.0f,  1.0f);
			glVertex3f( 2.0f, -3.0f, -1.0f);
			glVertex3f( 2.0f, -1.0f, -1.0f);
			glVertex3f( 2.0f, -1.0f,  1.0f);
		glEnd();
	glEndList();

	glNewList(BlockType+2,GL_COMPILE);		//3 - O
		glMaterialfv(GL_FRONT,GL_AMBIENT,BlockAmbient);
		glMaterialfv(GL_FRONT,GL_SPECULAR,BlockSpecular);
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glBegin(GL_QUADS);
			//Front
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-2.0f, -2.0f, 1.0f);
			glVertex3f(-2.0f,  2.0f, 1.0f);
			glVertex3f( 2.0f,  2.0f, 1.0f);
			glVertex3f( 2.0f, -2.0f, 1.0f);
			//Back
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-2.0f, -2.0f, -1.0f);
			glVertex3f(-2.0f,  2.0f, -1.0f);
			glVertex3f( 2.0f,  2.0f, -1.0f);
			glVertex3f( 2.0f, -2.0f, -1.0f);
			//Top
			glNormal3f( 0.0f,  1.0f, 0.0f);
			glVertex3f(-2.0f,  2.0f,  1.0f);
			glVertex3f(-2.0f,  2.0f, -1.0f);
			glVertex3f( 2.0f,  2.0f, -1.0f);
			glVertex3f( 2.0f,  2.0f,  1.0f);
			//Bottom
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f(-2.0f, -2.0f,  1.0f);
			glVertex3f(-2.0f, -2.0f, -1.0f);
			glVertex3f( 2.0f, -2.0f, -1.0f);
			glVertex3f( 2.0f, -2.0f,  1.0f);
			//Left
			glNormal3f(-2.0f,  0.0f, 0.0f);
			glVertex3f(-2.0f, -2.0f,  1.0f);
			glVertex3f(-2.0f, -2.0f, -1.0f);
			glVertex3f(-2.0f,  2.0f, -1.0f);
			glVertex3f(-2.0f,  2.0f,  1.0f);
			//Right
			glNormal3f( 1.0f,  0.0f, 0.0f);
			glVertex3f( 2.0f, -2.0f,  1.0f);
			glVertex3f( 2.0f, -2.0f, -1.0f);
			glVertex3f( 2.0f,  2.0f, -1.0f);
			glVertex3f( 2.0f,  2.0f,  1.0f);
		glEnd();
	glEndList();

	glNewList(BlockType+3,GL_COMPILE);		//4 - Z
		glMaterialfv(GL_FRONT,GL_AMBIENT,BlockAmbient);
		glMaterialfv(GL_FRONT,GL_SPECULAR,BlockSpecular);
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glBegin(GL_QUADS);
			//FrontA
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-3.0f,  0.0f, 1.0f);
			glVertex3f(-3.0f,  2.0f, 1.0f);
			glVertex3f( 1.0f,  2.0f, 1.0f);
			glVertex3f( 1.0f,  0.0f, 1.0f);
			//FrontB
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-1.0f, -2.0f, 1.0f);
			glVertex3f(-1.0f,  0.0f, 1.0f);
			glVertex3f( 3.0f,  0.0f, 1.0f);
			glVertex3f( 3.0f, -2.0f, 1.0f);
			//BackA
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-3.0f,  0.0f, -1.0f);
			glVertex3f(-3.0f,  2.0f, -1.0f);
			glVertex3f( 1.0f,  2.0f, -1.0f);
			glVertex3f( 1.0f,  0.0f, -1.0f);
			//BackB
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f, -2.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f, -2.0f, -1.0f);
			//TopA
			glNormal3f( 0.0f,  1.0f,  0.0f);
			glVertex3f(-3.0f,  2.0f,  1.0f);
			glVertex3f(-3.0f,  2.0f, -1.0f);
			glVertex3f( 1.0f,  2.0f, -1.0f);
			glVertex3f( 1.0f,  2.0f,  1.0f);
			//TopB
			glNormal3f( 0.0f,  1.0f,  0.0f);
			glVertex3f( 1.0f,  0.0f,  1.0f);
			glVertex3f( 1.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f,  1.0f);
			//BottomA
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f(-3.0f,  0.0f,  1.0f);
			glVertex3f(-3.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f,  1.0f);
			//BottomB
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f(-1.0f, -2.0f,  1.0f);
			glVertex3f(-1.0f, -2.0f, -1.0f);
			glVertex3f( 3.0f, -2.0f, -1.0f);
			glVertex3f( 3.0f, -2.0f,  1.0f);
			//LeftA
			glNormal3f(-1.0f,  0.0f,  0.0f);
			glVertex3f(-3.0f,  0.0f,  1.0f);
			glVertex3f(-3.0f,  0.0f, -1.0f);
			glVertex3f(-3.0f,  2.0f, -1.0f);
			glVertex3f(-3.0f,  2.0f,  1.0f);
			//LeftB
			glNormal3f(-1.0f,  0.0f,  0.0f);
			glVertex3f(-1.0f, -2.0f,  1.0f);
			glVertex3f(-1.0f, -2.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f,  1.0f);
			//RightA
			glNormal3f( 1.0f,  0.0f,  0.0f);
			glVertex3f( 1.0f,  0.0f,  1.0f);
			glVertex3f( 1.0f,  0.0f, -1.0f);
			glVertex3f( 1.0f,  2.0f, -1.0f);
			glVertex3f( 1.0f,  2.0f,  1.0f);
			//RightB
			glNormal3f( 1.0f,  0.0f,  0.0f);
			glVertex3f( 3.0f, -2.0f,  1.0f);
			glVertex3f( 3.0f, -2.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f,  1.0f);
		glEnd();
	glEndList();

	glNewList(BlockType+4,GL_COMPILE);		//5 - T
		glMaterialfv(GL_FRONT,GL_AMBIENT,BlockAmbient);
		glMaterialfv(GL_FRONT,GL_SPECULAR,BlockSpecular);
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glBegin(GL_QUADS);
			//FrontA
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-3.0f,  0.0f, 1.0f);
			glVertex3f(-3.0f,  2.0f, 1.0f);
			glVertex3f( 3.0f,  2.0f, 1.0f);
			glVertex3f( 3.0f,  0.0f, 1.0f);
			//FrontB
			glNormal3f( 0.0f,  0.0f, 1.0f);
			glVertex3f(-1.0f, -2.0f, 1.0f);
			glVertex3f(-1.0f,  0.0f, 1.0f);
			glVertex3f( 1.0f,  0.0f, 1.0f);
			glVertex3f( 1.0f, -2.0f, 1.0f);
			//BackA
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-3.0f,  0.0f, -1.0f);
			glVertex3f(-3.0f,  2.0f, -1.0f);
			glVertex3f( 3.0f,  2.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f, -1.0f);
			//BackB
			glNormal3f( 0.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f, -2.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f, -1.0f);
			glVertex3f( 1.0f,  0.0f, -1.0f);
			glVertex3f( 1.0f, -2.0f, -1.0f);
			//Top
			glNormal3f( 0.0f,  1.0f,  0.0f);
			glVertex3f(-3.0f,  2.0f,  1.0f);
			glVertex3f(-3.0f,  2.0f, -1.0f);
			glVertex3f( 3.0f,  2.0f, -1.0f);
			glVertex3f( 3.0f,  2.0f,  1.0f);
			//BottomA
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f(-3.0f,  0.0f,  1.0f);
			glVertex3f(-3.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f,  1.0f);
			//BottomB
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f( 1.0f,  0.0f,  1.0f);
			glVertex3f( 1.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  0.0f,  1.0f);
			//BottomC
			glNormal3f( 0.0f, -1.0f,  0.0f);
			glVertex3f(-1.0f, -2.0f,  1.0f);
			glVertex3f(-1.0f, -2.0f, -1.0f);
			glVertex3f( 1.0f, -2.0f, -1.0f);
			glVertex3f( 1.0f, -2.0f,  1.0f);
			//LeftA
			glNormal3f(-1.0f,  0.0f, 0.0f);
			glVertex3f(-3.0f,  0.0f,  1.0f);
			glVertex3f(-3.0f,  0.0f, -1.0f);
			glVertex3f(-3.0f,  2.0f, -1.0f);
			glVertex3f(-3.0f,  2.0f,  1.0f);
			//LeftB
			glNormal3f(-1.0f,  0.0f, 0.0f);
			glVertex3f(-1.0f, -2.0f,  1.0f);
			glVertex3f(-1.0f, -2.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f, -1.0f);
			glVertex3f(-1.0f,  0.0f,  1.0f);
			//RightA
			glNormal3f( 1.0f,  0.0f, 0.0f);
			glVertex3f( 3.0f,  0.0f,  1.0f);
			glVertex3f( 3.0f,  0.0f, -1.0f);
			glVertex3f( 3.0f,  2.0f, -1.0f);
			glVertex3f( 3.0f,  2.0f,  1.0f);
			//RightB
			glNormal3f( 1.0f,  0.0f, 0.0f);
			glVertex3f( 1.0f, -2.0f,  1.0f);
			glVertex3f( 1.0f, -2.0f, -1.0f);
			glVertex3f( 1.0f,  0.0f, -1.0f);
			glVertex3f( 1.0f,  0.0f,  1.0f);
		glEnd();
	glEndList();

	glNewList(BlockType+5,GL_COMPILE);		//6 - (L)
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
		glCallList(BlockType+1);
	glEndList();

	glNewList(BlockType+6,GL_COMPILE);		//7 - (Z)
		glMaterialf(GL_FRONT,GL_SHININESS,60.0f);
		glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
		glCallList(BlockType+3);
	glEndList();

}
//---------------------------------------------------------------------------
void TForm1::BuildFont()
{
	HFONT font;										// Windows Font ID

	base = glGenLists(96);
	font = CreateFont(  -24,						// Height Of Font
						0,							// Width Of Font
						0,							// Angle Of Escapement
						0,							// Orientation Angle
						FW_BOLD,					// Font Weight
						FALSE,						// Italic
						FALSE,						// Underline
						FALSE,						// Strikeout
						ANSI_CHARSET,				// Character Set Identifier
						OUT_TT_PRECIS,				// Output Precision
						CLIP_DEFAULT_PRECIS,		// Clipping Precision
						ANTIALIASED_QUALITY,		// Output Quality
						FF_DONTCARE|DEFAULT_PITCH,	// Family And Pitch
						"Times New Roman");			// Font Name
	SelectObject(hDC, font);
	wglUseFontOutlines(	hDC,				// Select The Current DC
						32,					// Starting Character
						96,					// Number Of Display Lists To Build
						base,				// Starting Display Lists
						0.0f,				// Deviation From The True Outlines
						0.2f,				// Font Thickness In The Z Direction
						WGL_FONT_POLYGONS,	// Use Polygons, Not Lines
						gmf);				// Address Of Buffer To Recieve Data
}
//---------------------------------------------------------------------------
void __fastcall TForm1::IdleLoopLogo(TObject*, bool& done)
{
    GLfloat Y,Z;
    float Step;

	if(Form1->Active)
	{
		done = false;
        Zegar.OdczytajCzas();
        
		Y=cos(RotAngle)*30;
		Z=sin(RotAngle)*20;

		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		glTranslatef(1.0f,0.0f,-5.5f);
		glRotatef(Y,0.0f,1.0f,0.0f);
		glRotatef(Z,0.0f,0.0f,1.0f);
		glCallList(logo);
		SwapBuffers(hDC);

        Step=Zegar.OdczytajInterwal()*0.0025;
		if((RotAngle+=Step)>2*PI) RotAngle=0;
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::IdleLoopEnd(TObject*, bool& done)
{
	GLfloat size;
    float Step;
	char Text[50];

	if(Form1->Active)
	{
		done = false;

		size=sin(RotAngle)/8.0f+1.0f;

		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

		glLoadIdentity();
		glTranslatef(0.8f-(size*2.5),0.0f,-4.7f);
		glScalef(size,size,size);
		glCallList(end);

		sprintf(Text,"%.4d",Plansza->Score);
		glTranslatef(-3.7f,-1.0f,0.0f);
		DrawText(Text);
		glDisable(GL_COLOR_MATERIAL);
		glDisable(GL_LIGHT0);
		SwapBuffers(hDC);

        Step=Zegar.OdczytajInterwal()*0.0020;
		if((RotAngle+=Step)>2*PI) RotAngle=0;
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::IdleLoopPlay(TObject*, bool& done)
{
    float Step;
    int i;

	if(Form1->Active)
	{
		done = false;

		RenderGLScene();
		SwapBuffers(hDC);
		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

        Step=Zegar.OdczytajInterwal()*0.025;
		if((RotAngle+=Step)>360) RotAngle=0;
	}
}
//---------------------------------------------------------------------------
void TForm1::StartAnim()
{
    GLfloat size=0.0f;
	while(size<1.0)
	{
        Zegar.OdczytajCzas();

		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		glTranslatef(0.5f-(size*1.45f),0.0f,-2.0);
		glScalef(size,size,size);
		glCallList(start);
		SwapBuffers(hDC);

        size+=Zegar.OdczytajInterwal()*0.002;
	}
}
//---------------------------------------------------------------------------
void TForm1::BonusAnim(int Lines)
{
    GLfloat rot=0;
    float i=0;

    Application->OnIdle = NULL;
    
	while(rot<PI/2)
	{
        Zegar.OdczytajCzas();

		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		RenderGLScene();
		glLoadIdentity();
		glTranslatef(2*cos(rot), 2*cos(rot), -5*cos(rot)-2);
		glRotatef(rot*229, 1.0f, 0.0f, 0.0f);
		glRotatef(rot*229, 0.0f, 0.0f, 1.0f);
		glCallList(bonus);
		SwapBuffers(hDC);

        rot+=Zegar.OdczytajInterwal()*0.001;
	}

    rot=0;
	while(rot<PI)
	{
        Zegar.OdczytajCzas();

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glFrustum(-1.0f, 2.0f, -1.0f, 1.0f, 2.0f+sin(rot)/10.0f, 20.0f);
		glMatrixMode(GL_MODELVIEW);

		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		RenderGLScene();
		glLoadIdentity();
		glTranslatef(0.0f, 0.0f, -2.1f);
		glCallList(bonus);
		SwapBuffers(hDC);

        rot+=Zegar.OdczytajInterwal()*0.05f;
	}

	while(i<=Lines*200)
	{
        Zegar.OdczytajCzas();

		if(int(i)==i)
            Plansza->Score++;
		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		RenderGLScene();
		glLoadIdentity();
		glTranslatef(0.0f, 0.0f, -2.1f);
		glCallList(bonus);
		SwapBuffers(hDC);

        i+=Zegar.OdczytajInterwal()*0.2f;
	}

	//to_do	-	do osobnej funkcji blyskanie i stosowac
	//			po kazdej zniknietej linii

	//anim lines flashing before destroy
	for(int k=0;k<25;k++)
	{
		for (int i=0;i<5*Lines;i++)
		{
			Plansza->TabLinii[i].Flash(k%5);
		}
		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		RenderGLScene();
		glLoadIdentity();
		glTranslatef(0.0f, 0.0f, -2.1f);
		glCallList(bonus);
		SwapBuffers(hDC);
	}

	Plansza->Przesun(5*Lines,5*Lines);
	//update ActiveList
	for(int i=0;i<5*Lines;i++)
	{
		for(int j=0;j<ActiveListPointer;j++)
		{
			while(j<ActiveListPointer && ActiveList[j]->Sprawdz(i) )
			{
				delete ActiveList[j];
				ActiveList[j]=ActiveList[--ActiveListPointer];
			}
		}
	}
	//move active blocks down through destroyed lines
	for(int j=0;j<ActiveListPointer;j++)
		if(ActiveList[j]->y>5*Lines-1)
			ActiveList[j]->y-=5*Lines;

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	RenderGLScene();
	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, -2.1f);
	glCallList(bonus);
	SwapBuffers(hDC);
	
	Start->Enabled=true;	//start timer
}
//---------------------------------------------------------------------------
void TForm1::DrawScore()
{
	char Text[50];
	GLfloat Ambient[]={ 0.5, 0.5, 0.5, 0.5 };
	GLfloat Diffuse[]={ 0.0, 0.5, 1.0, 0.5 };
	GLfloat Diffuse2[]={ 0.0, 0.5, 1.0, 0.5 };
	GLfloat Diffuse3[]={ 0.0, 0.5, 1.0, 0.5 };
	GLfloat Specular[]={ 1.0, 1.0, 1.0, 1.0 };

	glMaterialfv(GL_FRONT,GL_AMBIENT,Ambient);
	glMaterialfv(GL_FRONT,GL_SPECULAR,Specular);
	glMaterialf(GL_FRONT,GL_SHININESS,60.0f);

	glEnable(GL_LIGHT2);

	glMaterialfv(GL_FRONT,GL_DIFFUSE,Diffuse);
	sprintf(Text,"%.4d",Plansza->Score);
	glLoadIdentity();
	glTranslatef(2.03f,0.4f,-3.0);
	glScalef(0.4,0.4,0.4);
	DrawText(Text);

	glMaterialfv(GL_FRONT,GL_DIFFUSE,Diffuse2);
	sprintf(Text,"%.2d",Plansza->Lines);
	glLoadIdentity();
	glTranslatef(3.0f,0.0f,-4.0f);
	glScalef(0.5,0.5,0.5);
	DrawText(Text);

	glMaterialfv(GL_FRONT,GL_DIFFUSE,Diffuse3);
	sprintf(Text,"%d",Plansza->Level);
	glLoadIdentity();
	glTranslatef(2.3f,-0.8f,-3.0f);
	glScalef(0.7,0.7,0.7);
	DrawText(Text);

	glDisable(GL_LIGHT2);
}
//---------------------------------------------------------------------------
void TForm1::DrawNextBlock()
{
	static GLfloat BlockDiffuse[7][4]=
	{
		{1.0f,0.0f,0.0f,0.5f},{0.0f,1.0f,1.0f,0.5f},{1.0f,0.5f,0.0f,0.5f},
		{0.0f,1.0f,0.0f,0.5f},{1.0f,1.0f,0.0f,0.5f},{1.0f,0.0f,1.0f,0.5f},
		{0.0f,0.0f,1.0f,0.5f}
	};

	glMaterialfv(GL_FRONT,GL_DIFFUSE,BlockDiffuse[NextBlock-1]);

	glEnable(GL_LIGHT3);
	glLoadIdentity();
	glTranslatef(3.2f, 1.5f, -4.0f);
	glScalef(0.1f, 0.075f, 0.1f);
	glRotatef(-65.0f, 0.0f, 1.0f, 0.0f);
	glRotatef(RotAngle*Plansza->Level, 1.0f, 0.0f, 1.0f);
	glCallList(BlockType+NextBlock-1);
	glDisable(GL_LIGHT3);
}


//GUI serving methodes
//set the level of current game----------------------------------------------
void TForm1::SetLevel(int num)
{
 N11->Checked=False; N21->Checked=False;  //clean menu checkers
 N31->Checked=False; N41->Checked=False;
 N51->Checked=False; N61->Checked=False;
 N71->Checked=False; N81->Checked=False;
 N91->Checked=False; N101->Checked=False;
//set new check field and level number
 switch(num)
 {
  case 1: N11->Checked=True;
		  Plansza->Level=1;
		  break;
  case 2: N21->Checked=True;
		  Plansza->Level=2;
		  break;
  case 3: N31->Checked=True;
		  Plansza->Level=3;
		  break;
  case 4: N41->Checked=True;
		  Plansza->Level=4;
		  break;
  case 5: N51->Checked=True;
		  Plansza->Level=5;
		  break;
  case 6: N61->Checked=True;
		  Plansza->Level=6;
		  break;
  case 7: N71->Checked=True;
		  Plansza->Level=7;
		  break;
  case 8: N81->Checked=True;
		  Plansza->Level=8;
		  break;
  case 9: N91->Checked=True;
		  Plansza->Level=9;
		  break;
  case 10:N101->Checked=True;
		  Plansza->Level=10;
		  break;
 }
}
void __fastcall TForm1::N11Click(TObject *Sender)
{ SetLevel(1);}
void __fastcall TForm1::N21Click(TObject *Sender)
{ SetLevel(2);}
void __fastcall TForm1::N31Click(TObject *Sender)
{ SetLevel(3);}
void __fastcall TForm1::N41Click(TObject *Sender)
{ SetLevel(4);}
void __fastcall TForm1::N51Click(TObject *Sender)
{ SetLevel(5);}
void __fastcall TForm1::N61Click(TObject *Sender)
{ SetLevel(6);}
void __fastcall TForm1::N71Click(TObject *Sender)
{ SetLevel(7);}
void __fastcall TForm1::N81Click(TObject *Sender)
{ SetLevel(8);}
void __fastcall TForm1::N91Click(TObject *Sender)
{ SetLevel(9);}
void __fastcall TForm1::N101Click(TObject *Sender)
{ SetLevel(10);}
//main form closing----------------------------------------------------------
void __fastcall TForm1::ExitClick(TObject *Sender)
{Form1->Close();}
//about form openinig--------------------------------------------------------
void __fastcall TForm1::AboutClick(TObject *Sender)
{
	bool tmp=Plansza->Run;
	Plansza->Run=false;
	AboutBox->ShowModal();
	SwapBuffers(hDC);
	Plansza->Run=tmp;
}
//help form opening----------------------------------------------------------
void __fastcall TForm1::InfoClick(TObject *Sender)
{
	bool tmp=Plansza->Run;
	Plansza->Run=false;
	Form2->ShowModal();
	SwapBuffers(hDC);
	Plansza->Run=tmp;
}
//Options->Blend-------------------------------------------------------------
void __fastcall TForm1::BlendClick(TObject *Sender)
{
	Blend->Checked=!Blend->Checked;
	if(Blend->Checked)
	{
		glDisable(GL_DEPTH_TEST);
		glEnable(GL_BLEND);
	}
	else
	{
		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
	}
}
//Options->Falling control---------------------------------------------------
void __fastcall TForm1::FallingClick(TObject *Sender)
{
	Falling->Checked=!Falling->Checked;
	KeyPressed=0;
}
//---------------------------------------------------------------------------
CKlocek* TForm1::LosujKlocek()
{
    int x=W/2-1, y=H-1;

    int t, p, c, tmp;
    CKlocek *Klocek;

    t=NextBlock;						//block type
    NextBlock=rand()%5+1;
    if(NextBlock==2 || NextBlock==4)    //choose L and Z direction
    {
	    tmp=rand()%2;
	    if(tmp)
		    NextBlock=NextBlock/2+5;
    }
    RotAngle=0;
    Klocek = new CKlocek(t,x,y,Plansza);
    return(Klocek);
}
//--------------------------------------------------------------------------
void TForm1::Graj()
{
    X = LosujKlocek();
    if(Falling->Checked)
	    KeyPressed=1;       //prevent accidental block falling
    Plansza->Run=true;      //keypad access flag (new block exist)

    X->Rysuj();

    if (!X->draw)			//game is over
    {
	    Plansza->Run=false;
	    Options->Enabled=false;
	    delete X;
	    for(int i=0;i<ActiveListPointer;i++)
		    delete ActiveList[i];
	    Application->OnIdle=IdleLoopEnd;
	    Form1->Go->Enabled=true;
	    Form1->Level->Enabled=true;
	    Form1->Move->Enabled=false;
    }
}

//block set, update score, explode full lines
int TForm1::Polozony(int Active)
{
	int Line=0;
	int tmp;
	CKlocek* tmpKlocek;

	Plansza->Score++;
	for (int i=(X->y);i>=0 && i>=(X->y-3);i--)
	{
		if (Plansza->TabLinii[i].Full)
		{
			Plansza->Przesun(i+1,1);
			Plansza->Score+=50;
			Plansza->Lines++;
			if (Plansza->Score > Plansza->Level*1000)
			{
				Form1->SetLevel(++Plansza->Level);
				Form1->Move->Interval=1000/Plansza->Level;
			}
			Line++;

			//update ActiveList
			for(int j=0;j<ActiveListPointer;j++)
			{
				while(j<ActiveListPointer && ActiveList[j]->Sprawdz(i) )
				{
					delete ActiveList[j];
					ActiveList[j]=ActiveList[--ActiveListPointer];
				}
			}
			//move blocks down through destroyed line
			for(int j=0;j<ActiveListPointer;j++)
            {
				if(ActiveList[j]->y>i)
					ActiveList[j]->y--;
            }
		}
	}

	if(!Line)
	{
		//add block to ActiveList
		if(!Active)
			ActiveList[ActiveListPointer++]=X;
	}
	else
	{
		delete X;
		//active blocks free falling
		for(int i=0;i<ActiveListPointer;i++)
		{
			tmp=ActiveList[i]->y;
			while(1)
			{
				ActiveList[i]->Rysuj();
				ActiveList[i]->y--;
				ActiveList[i]->Rysuj();
				if (!ActiveList[i]->draw)
				{
					ActiveList[i]->y++;
					ActiveList[i]->Rysuj();
					break;	//stop falling if ground reached
				}
			}
			//the block has fallen
			if(tmp!=ActiveList[i]->y)
			{
				X=ActiveList[i];
				ActiveList[i]=ActiveList[--ActiveListPointer];
				if((tmp=Polozony(1))!=0)
				{
					Line+=tmp;
					break;	//finish if new line was full
				}
			}
		}
	}
	return(Line);
}
//start new game------------------------------------------------------------
void __fastcall TForm1::GoClick(TObject *Sender)
{
    for(int i=0;i<H;i++)
	    Plansza->UsunLinie(i);
    Plansza->Score=0;
    Plansza->Lines=0;
    NextBlock=rand()%5+1;
    ActiveListPointer=0;

    Application->OnIdle=NULL;

    Move->Interval=1000/Plansza->Level;
    Go->Enabled=false;
    Level->Enabled=false;
    Options->Enabled=true;
    Start->Enabled=true;
    SetLevel(1);
    StartAnim();
}

//Start caption off
void __fastcall TForm1::StartTimer(TObject *Sender)
{
    Start->Enabled=false;
    Graj();
    Application->OnIdle=IdleLoopPlay;
    Form1->Move->Enabled=true;
    Zegar.OdczytajCzas();
}

//keypads handle-------------------------------------------------------------
void __fastcall TForm1::FormKeyDown(TObject *Sender,WORD &Key,TShiftState Shift)
{
    char Text[150];

    switch(Key)
    {
    case VK_NUMPAD1:
        c2++;
        glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, c2);
		break;
    case VK_NUMPAD2:
        c2--;
		glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, c2);
		break;

    case VK_NUMPAD3:
        e2+=0.1;
		glLightf(GL_LIGHT1, GL_SPOT_EXPONENT, e2);
		break;
    case VK_NUMPAD4:
        e2-=0.1;
		glLightf(GL_LIGHT1, GL_SPOT_EXPONENT, e2);
		break;

    case VK_PRIOR:
        x2+=0.1;
		break;
    case VK_NEXT:
        x2-=0.1;
		break;
    case VK_HOME:
        y2+=0.1;
		break;
    case VK_END:
        y2-=0.1;
		break;

    case VK_SPACE:
        sprintf(Text,"%f %f | %f %f",c2,e2,x2,y2);
		ShowMessage(Text);
		break;
    }

    if (Plansza->Run)
    {
	    switch(Key)
	    {
	    case VK_LEFT:
            X->Rysuj();
			X->x--;
			X->Rysuj();
			if (!X->draw)
			{
			    X->x++;
				X->Rysuj();
            }
			break;
	    case VK_RIGHT:
            X->Rysuj();
			X->x++;
			X->Rysuj();
			if (!X->draw)
			{
			    X->x--;
				X->Rysuj();
            }
			break;
	    case VK_UP:
            X->Rysuj();
			X->pozycja=(X->pozycja)%4+1;
			X->Rysuj();
			if (!X->draw)
			{
			    X->pozycja--;
				if (X->pozycja==0)
				    X->pozycja=4;
                X->Rysuj();
            }
			break;
	    case VK_DOWN:
            if(Falling->Checked)
			{
			    if(!KeyPressed)
				    MoveTimer(Sender);
            }
			else
			{
			    if(!KeyPressed)
				{
					KeyPressed=1;		//lock KeyDown
					while(1)
					{
					    X->Rysuj();
						X->y--;
						X->Rysuj();
						if (!X->draw)
						{
							X->y++;
							X->Rysuj();
							break;
						}
                    }
					Plansza->Run=false;
					int tmp=Polozony(0);
					if(tmp>4)
					    BonusAnim(tmp-4);
                    else
                        Graj();
                    break;
                }
            }
	    }
    }
}
//unlock KeyDown-------------------------------------------------------------
void __fastcall TForm1::FormKeyUp(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	if(Key==VK_DOWN)
		KeyPressed=0;
}
//stepping the blocks down---------------------------------------------------
void __fastcall TForm1::MoveTimer(TObject *Sender)
{
    if (Plansza->Run && Form1->Active)
    {
	    X->Rysuj();
	    X->y--;
	    X->Rysuj();
	    if (!X->draw)
	    {
		    X->y++;
		    X->Rysuj();
		    Plansza->Run=false;
		    int tmp=Polozony(0);
		    if(tmp>4)
			    BonusAnim(tmp-4);
		    else
                Graj();
	    }
    }
}

