;COPROCESSOR 3D GOURAUD SHADED VEKTORS + CAMERA FUNCTION + LIGHT
;FRAME COUNTER PRESENT
;CODE BY MOMAT

.MODEL huge
.486
.STACK 100h
.DATA

include objects\auto.inc
include phong.pal

TablicaPunktow3d dd Vertices dup (0,0,0)
TablicaPunktow2d dd Vertices dup (0,0)
TablicaWersorow  dd Vertices dup (0,0,0)

TablicaKolorow dd Vertices dup (0)
TablicaWidocznosci dw Faces dup(0)

katX    dd 0.0
katY    dd 0.0
katZ    dd 0.0
radian  dd 0.0174532925
radian2 dd 6.283185307

XX      dd 0            ;wspolrzedne
YY      dd 0            ;    2D

X       dd 0.0          ;wspolrzedne
Y       dd 0.0          ;    3D
Z       dd 0.0          ;  obiektu

Lx      dd 0.0          ;wspolrzedne
Ly      dd 0.0          ;  swiatla
Lz      dd 0.0

Lxx     dd 0.0          ;stale dla swiatla
Lyy     dd 0.0
Lzz     dd -1.0

katLx   dd 0.0          ;katy do obrotu
katLy   dd 0.0          ;   swiatla
Zoom    dd 0.1          ;zblizenie

X1      dd 0            ;wspolrzedne wierzcholkow
X2      dd 0            ;face'a
X3      dd 0
Y1      dd 0
Y2      dd 0
Y3      dd 0
K1      dd 0            ;kolory punktow face'a
K2      dd 0
K3      dd 0

IleWidac dw 0

Czas     dw 0           ;zmienne do miernika szybkosci
Frame    dw 0
Time     dd 0.055       ;czas trwania 1 taktu zegara
IntSeg   dw ?
IntOffs  dw ?
Tekst    db 13,10,'       klatek/sek$'
Dycha    dd 10.0
Setka    dd 100.0

Ekran SEGMENT USE16 'EKRAN'
      Bufor db 64000 dup (1)
Ekran ENDS

.CODE

include proc\obrotyf.inc
include proc\kamera.inc
include proc\qsort.inc
include proc\light.inc
include proc\gouraud.inc

Przerwanie1Ch:
        push ds
        push ax
        mov ax,SEG Czas
        mov ds,ax
        inc Czas
        pop ax
        pop ds
        iret

Start:  mov ax,_DATA
        mov ds,ax
        mov ax,13h
        int 10h                 ;tryb graficzny
        call UstawPalete
        call PrzeliczPolaczenia
        lea di,PunktyKamery
        call LiczWektory
        fninit

        mov ax,351ch            ;adres przerwania 1Ch w ES:BX
        int 21h
        mov IntOffs,bx          ;zapamietanie wektora przerwania
        mov IntSeg,es
        lea dx,Przerwanie1Ch    ;przechwycenie 1Ch
        push cs
        pop ds
        mov ax,251ch
        int 21h
        mov ax,_DATA
        mov ds,ax

Main:   mov ax,Ekran           ;czyszczenie bufora ekranu
        mov es,ax
        xor di,di
        mov eax,20202020h
        mov cx,320*200/4
        rep stosd

        call ObiektTransfer     ;kopiowanie punktow do tablicy 3d przed obrotem
        call Obroty             ;przeliczenie obrotow w tablicy 3d
        call Obserwator         ;przeliczenie tablicy 3d na 2d
        call Kolory             ;obliczenie kolorow w wierzcholkach
        call Widocznosc         ;pozycji widocznej strony face'a
        call Sortowanie

        fld radian      ;radian do ST(0)
        fadd KatX       ;dodaj do ST(0)
        fcom radian2    ;porownaj z 2*pi rad
        fnstsw ax       ;flagi koprocka do ax
        sahf            ;ah na flagi procka
        jb Dalej
        fld radian
        ffree st(1)
Dalej:  fst KatX
        fst KatY
        fstp KatZ       ;zdjecie ze stosu
        inc Frame

        jmp Klawisz

NaEkran:
        push ds
        mov ax,Ekran
        mov bx,0a000h
        mov ds,ax
        mov es,bx
        mov si,0
        mov di,0
        mov cx,320*200/4
        rep movsd
        pop ds
        ret

PrzeliczPolaczenia:             ;zmniejsza ilosc obliczen w trakcie animacji
        lea si,Lacz
        mov cx,Faces*3          ;ilosc face'ow * 3
Loop1:  lodsw                   ;wczytanie liczby z tablicy polaczen
        shl ax,3                ;razy 8 - (4B Xp,4B Yp)= 8 bajtow
        mov [si-2],ax           ;zapis do tablicy
        loop Loop1
        ret

UstawPalete:
        mov cx,768
        lea si,Pal
        mov dx,03c8h
        xor al,al
        out dx,al
        inc dx
        cld
        rep outsb
        ret

Kolory: lea si,TablicaPunktow3d
        lea di,TablicaKolorow
        lea bx,TablicaWersorow
        mov cx,Vertices
KoloryPetla:
        fld Lx
        fld Ly
        fld Lz
        fsub DWORD PTR [si][8]
        fxch st(1)              ;YZX
        fsub DWORD PTR [si][4]
        fxch st(2)              ;XZY
        fsub DWORD PTR [si]
        fxch st(1)              ;ZXY
        fstp SZp
        fstp SXp
        fstp SYp

        fld DWORD PTR [bx]
        fld DWORD PTR [bx][4]
        fld DWORD PTR [bx][8]
        fxch st(1)
        fstp NYp
        fstp NZp
        fstp NXp
        call LiczKolor

        fistp DWORD PTR [di]
        cmp DWORD PTR [di],0
        jge Plus
        mov DWORD PTR [di],0
Plus:   add di,4
        add si,12
        add bx,12
        dec cx
        jne KoloryPetla
        ret

Widocznosc:
        lea bp,Lacz
        lea di,TablicaWidocznosci
        lea bx,TablicaPunktow2d
        mov cx,Faces
WidocznoscPetla:
        mov si,ds:[bp]
        mov eax,[bx][si]                ;X1
        mov si,ds:[bp][2]
        sub eax,[bx][si]                ;X1-X2
        mov si,ds:[bp][4]
        mov edx,[bx][si][4]             ;Y3
        mov si,ds:[bp][2]
        sub edx,[bx][si][4]             ;Y3-Y2
        imul dx                         ;(X1-X2)*(Y3-Y2)
        shl edx,16
        mov dx,ax
        push edx
        mov eax,[bx][si]
        mov si,ds:[bp][4]
        sub eax,[bx][si]                ;X2-X3
        mov si,ds:[bp][2]
        mov edx,[bx][si][4]
        mov si,ds:[bp]
        sub edx,[bx][si][4]             ;Y2-Y3
        imul dx                         ;(X2-X3)*(Y2-Y1)
        shl edx,16
        mov dx,ax
        pop eax
        cmp eax,edx
        jl FaceNiewidoczny
        mov [di],bp          ;offset face'a do tablicy widocznosci
        add di,2
        inc IleWidac
FaceNiewidoczny:
        add bp,6
        dec cx
        jne WidocznoscPetla
        ret

Sortowanie:
        lea bp,TablicaWidocznosci
        lea si,TablicaPunktow3d
        lea bx,ZBuffor
        mov cx,IleWidac
SumujZety:
        mov di,ds:[bp]          ;offset face'a w Lacz z Tab.Widocznosci
        push bp
        mov ax,[di]             ;w Lacz sa przemnozone przez 8 wskazniki
        mov bp,[di]             ;punktow, tu potrzebne jest mnozenie
        sar ax,1                ;przez 12 (mamy do czynienia z punktami
                                ;w tablicy 3D)
        mov dx,[di][2]          ;p2 (punkt drugi) - power of pipeline
        add bp,ax               ;p1
        mov ax,[di][4]          ;p3 (trzeci)
        fld DWORD PTR ds:[si][bp][8]  ;p1 - wspolrzedna Z pierwszego punktu
        sar dx,1                ;p2
        mov bp,[di][2]          ;p2
        sar ax,1                ;p3
        add bp,dx               ;p2
        fadd DWORD PTR ds:[si][bp][8] ;p2
        mov bp,[di][4]
        add bp,ax
        fadd DWORD PTR ds:[si][bp][8]
        ;fadd MaxSum
        fstp DWORD PTR [bx]     ;suma do ZBuffora
        mov [bx][4],di          ;offset face'a do ZBuffora
        pop bp
        add bx,6
        add bp,2
        dec cx
        jne SumujZety

        call Sort               ;sortowanie ZBuffora

PrzygotujRysowanie:
        lea si,TablicaPunktow2d
        lea di,TablicaKolorow
        xor eax,eax
        lea bx,ZBuffor          ;bx = ofsset ZBuffora + 6*IleWidac - 2
        mov ax,IleWidac         ;ilosc face'ow
        sub bx,2
        lea eax,[eax+eax*2]
        shl ax,1
        add bx,ax
PrzygotujPetla:
        mov bp,[bx]             ;offset face'a z ZBuffora
        push bx
        mov bx,ds:[bp]          ;offset punktu z tablicy polaczen
        mov eax,[si][bx]        ;X1 z tablicy punktow 2d
        mov X1,eax
        mov eax,[si][bx][4]     ;Y1        -   ||   -
        mov Y1,eax
        sar bx,1
        mov eax,[di][bx]
        mov K1,eax
        mov bx,ds:[bp][2]
        mov eax,[si][bx]        ;X2 z tablicy punktow 2d
        mov X2,eax
        mov eax,[si][bx][4]     ;Y2      -   ||   -
        mov Y2,eax
        sar bx,1
        mov eax,[di][bx]
        mov K2,eax
        mov bx,ds:[bp][4]
        mov eax,[si][bx]        ;X3 z tablicy punktow 2d
        mov X3,eax
        mov eax,[si][bx][4]     ;Y3        -   ||   -
        mov Y3,eax
        sar bx,1
        mov eax,[di][bx]
        mov K3,eax
        push di
        push cx
        pushf
        push es
        call GouraudShade
        pop es
        popf
        pop cx
        pop di
        pop bx
        sub bx,6                ;zmniejszenie offsetu ZBuffora
        dec IleWidac
        jne PrzygotujPetla

;narysowanie swiatla
        lea si,Lx               ;punkt swiatla
        lea di,Lx
        call Camera
        mov ax,Ekran
        mov es,ax
        mov edi,YY
        mov bx,di
        shl di,8
        shl bx,6
        add di,bx
        mov ecx,XX
        add di,cx
        mov BYTE PTR es:[di],255

        call Raster
        jmp NaEkran             ;ret automatycznie


ObiektTransfer:
        push ds
        pop es
        lea si,Obiekt
        lea di,TablicaPunktow3d
        mov cx,Vertices*3
        rep movsd
        lea si,Wersor
        lea di,TablicaWersorow
        mov cx,Vertices*3
        rep movsd
        ret

Obroty:
        lea di,TablicaPunktow3d
        mov cx,Vertices
ObrotyPetla:
        mov eax,[di]            ;wspolrzedna X
        mov ebx,[di][4]         ;wspolrzedna Y
        mov edx,[di][8]         ;wspolrzedna Z
        mov X,eax
        mov Y,ebx
        mov Z,edx

        call RotacjaX           ;obroty X, Y, Z

        mov eax,X
        mov ebx,Y
        mov edx,Z
        mov [di],eax
        mov [di][4],ebx
        mov [di][8],edx
        add di,12
        dec cx
        jne ObrotyPetla

        lea di,TablicaWersorow
        mov cx,Vertices
ObrotyPetla2:
        mov eax,[di]            ;wspolrzedna X
        mov ebx,[di][4]         ;wspolrzedna Y
        mov edx,[di][8]         ;wspolrzedna Z
        mov X,eax
        mov Y,ebx
        mov Z,edx

        call RotacjaX           ;obroty X, Y, Z

        mov eax,X
        mov ebx,Y
        mov edx,Z
        mov [di],eax
        mov [di][4],ebx
        mov [di][8],edx
        add di,12
        dec cx
        jne ObrotyPetla2

;obracamy swiatelko...
        push katX
        push katY
        push katZ
        mov eax,Lxx
        mov ebx,Lyy
        mov ecx,Lzz
        mov X,eax
        mov Y,ebx
        mov Z,ecx
        mov eax,katLx
        mov ebx,katLy
        mov katX,eax
        mov katY,ebx
        mov katZ,0      ;katLz zawsze = 0
        call RotacjaX
        mov eax,X
        mov ebx,Y
        mov ecx,Z
        mov Lx,eax
        mov Ly,ebx
        mov Lz,ecx
        pop katZ
        pop katY
        pop katX
        ret

Obserwator:
        lea si,TablicaPunktow3d
        lea di,TablicaPunktow2d
        mov cx,Vertices
PerspektywaPetla:
        call Camera
        add di,8
        add si,12
        dec cx
        jne PerspektywaPetla
        ret

Raster:         mov dx,3dah
RasterPetla:    in al,dx
                test al,8
                je RasterPetla
                ret

Lewo:   fld katLy
        fadd radian
        fst katLy
        jmp Main1
Prawo:  fld katLy
        fsub radian
        fst katLy
        jmp Main1
Gora:   fld katLx
        fsub radian
        fst katLx
        jmp Main1
Dol:    fld katLx
        fadd radian
        fst katLx
        jmp Main1
Przod:  fld Lzz
        fadd Zoom
        fst Lzz
        jmp Main1
Tyl:    fld Lzz
        fsub Zoom
        fst Lzz
Main1:  mov ah,0ch
        int 21h
        jmp Main

Kropka: mov BYTE PTR ds:[di][bp],2Eh
        dec bp
        jmp Konwersja

Klawisz:
        mov ah,01h
        int 16h
        jz Main
        cmp ah,75
        je Lewo
        cmp ah,77
        je Prawo
        cmp ah,72
        je Gora
        cmp ah,80
        je Dol
        cmp ah,78
        je Przod
        cmp ah,74
        je Tyl

        fild Czas
        fmul Time
        fidivr Frame            ;obliczenie ilosci klatek na sekunde
        fmul Setka
        lea di,Tekst
        mov cx,4
        mov bp,7
        fld Dycha
Konwersja:
        fld st(1)
        fprem
        fist Frame
        mov ax,Frame
        add ax,48
        mov ds:[di][bp],al
        fsubp st(2),st
        fdiv st(1),st
        dec bp
        cmp bp,5
        je Kropka
        loop Konwersja

        mov ax,3h               ;tryb tekstowy
        int 10h
        mov ah,9                ;wyswietlenie wartosci na ekranie
        mov dx,di
        int 21h
        mov dx,IntOffs          ;przywrocenie orginalnego 1Ch
        mov ds,IntSeg
        mov ax,251ch
        int 21h
ByeBye:
        mov ax,4c01h
        int 21h

END Start
