;*************************
;*  COPROCESSOR ROTATES  *
;*  FLOATING POINT DATA  *
;*  CODE BY MOMAT        *
;*************************
;konieczne:  okreslenie wartosci pkt. X, Y, Z, katow obrotu KatX, KatY, KatZ


RotacjaX:
        fld Y           ;Y,Z na stos
        fld Z
        fld KatX        ;wartosc kata w radianach na stos
        fsincos         ;sinus i cosinus ST(0)
        fld st(1)       ;kopiuj sinus na szczyt stosu
        fmul st,st(3)   ;sin*Z
        fld st(1)       ;kopiuj cosinus na szczyt stosu
        fmul st,st(5)   ;cos*Y
        fsubr           ;odejmowanie ST(1) od ST(0)
        fstp Y	        ;zdejmij ST(0) do Y

        fxch st(3)      ;Y na szczyt
        fmulp           ;sin*Y
        fxch st(2)      ;cos na szczyt
        fmulp           ;cos*Z
        faddp
        fstp Z

RotacjaY:
        fld X          ;X,Z na stos
        fld Z
        fld KatY        ;wartosc kata w radianach na stos
        fsincos         ;sinus i cosinus ST(0)
        fld st(1)       ;kopiuj sinus na szczyt stosu
        fmul st,st(3)   ;sin*Z
        fld st(1)       ;kopiuj cosinus na szczyt stosu
        fmul st,st(5)   ;cos*X
        fadd
        fstp X         ;zdejmij ST(0) do Y

        fxch st(3)      ;X na szczyt
        fmulp           ;sin*X
        fxch st(2)      ;cos na szczyt
        fmulp           ;cos*Z
        fsubr
        fstp Z

RotacjaZ:
        fld X          ;X,Y na stos
        fld Y
        fld KatZ        ;wartosc kata w radianach na stos
        fsincos         ;sinus i cosinus ST(0)
        fld st(1)       ;kopiuj sinus na szczyt stosu
        fmul st,st(3)   ;sin*Y
        fld st(1)       ;kopiuj cosinus na szczyt stosu
        fmul st,st(5)   ;cos*X
        fsubr           ;odejmowanie ST(1) od ST(0)
        fstp X         ;zdejmij ST(0) do X

        fxch st(3)      ;X na szczyt
        fmulp           ;sin*X
        fxch st(2)      ;cos na szczyt
        fmulp           ;cos*Y
        fadd
        fstp Y

        ret

