;************************
;*  COPROCESSOR CAMERA  *
;*  CODE BY MOMAT       *
;************************
;konieczne: umieszczenie adresu tab.pkt.kamery w DS:DI przed skokiem do
;           LiczWektory, umieszczenie adresu tab.pkt.2d w ES:DI oraz
;           tab.pkt.3d e DS:SI przed skokiem do Camera
;zmienia:   eax,di,si

.DATA
PunktyKamery dd 0.0,0.0,-1.0,0.0,0.0,-2.0,0.4,0.0,-1.0,0.0,0.4,-1.0
;               |   pkt.O   |    pkt.E   |   pkt.U    |   pkt.W   |
xE      dd 0.0          ;wspolrzedne
yE      dd 0.0          ;obserwatora
zE      dd 0.0
Vx      dd ?            ;  wspolrzedne
Vy      dd ?            ;    wektora
Vz      dd ?            ;obserwator->cel

Ux      dd ?            ;wspolrzedne
Uy      dd ?            ;  wektorow
Uz      dd ?            ;plaszczyzny
Wx      dd ?            ; rzutowania
Wy      dd ?
Wz      dd ?
V       dd 1.0          ;dl. wektora V
W       dd 0.4          ;dl. wektora W  (pion)
U       dd 0.4          ;dl. wektora U  (poziom)

xres    equ 320         ;rozdzielczosc
yres    equ 200         ;   ekranu
xrespol dd 160.0
yrespol dd 100.0
sx      dd 400.0        ;xres/(2*U)  if sx>sy then sx=sy else sy=sx
sy      dd 250.0        ;yres/(2*W)  sx*=xaspect, sy*=yaspect

.CODE
LiczWektory:
        mov eax,DWORD PTR ds:[di][12]
        mov xE,eax
        mov eax,DWORD PTR ds:[di][16]
        mov yE,eax
        mov eax,DWORD PTR ds:[di][20]
        mov zE,eax

        fld DWORD PTR ds:[di]       ;wspol. wektora V
        fsub xE
        fstp Vx
        fld DWORD PTR ds:[di][4]
        fsub yE
        fstp Vy
        fld DWORD PTR ds:[di][8]
        fsub zE
        fstp Vz

        fld DWORD PTR ds:[di][24]   ;wspol. wektora U
        fsub DWORD PTR ds:[di]
        fstp Ux
        fld DWORD PTR ds:[di][28]
        fsub DWORD PTR ds:[di][4]
        fstp Uy
        fld DWORD PTR ds:[di][32]
        fsub DWORD PTR ds:[di][8]
        fstp Uz

        fld DWORD PTR ds:[di][36]   ;wspol. wektora W
        fsub DWORD PTR ds:[di]
        fstp Wx
        fld DWORD PTR ds:[di][40]
        fsub DWORD PTR ds:[di][4]
        fstp Wy
        fld DWORD PTR ds:[di][44]
        fsub DWORD PTR ds:[di][8]
        fstp Wz

        ret

Camera: mov eax,[si]    ;wspolrzedna X
        mov X,eax
        fld X
        fsub xE         ;x wektora obserwator->punkt (EP)
        fst X
        mov eax,[si][4] ;wspolrzedna Y
        mov Y,eax
        fld Y
        fsub yE         ;y wektora obserwator->punkt (EP)
        fst Y
        mov eax,[si][8] ;wspolrzedna Z
        mov Z,eax
        fld Z
        fsub zE         ;z wektora obserwator->punkt (EP)
        fst Z

        fmul Vz         ;EPz * Vz
        fxch            ;ST(1) do ST(0)
        fmul Vy         ;EPy * Vy
        fxch st(2)      ;ST(2) do ST(0)
        fmul Vx         ;EPx * Vx
        faddp
        faddp           ;suma iloczynow w ST(0) - iloczyn skalarny EPoV
        ftst            ;porownaj EPoV z 0
        fnstsw ax       ;flagi koprocka do ax
        sahf            ;ah na flagi procka
        jna Invisible
        fld st
        fmul U          ;EPoV * U
        fxch
        fmul W          ;EPoV * W
        fld X
        fld Y
        fld Z
        fmul Uz         ;EPz * Uz
        fxch
        fmul Uy         ;EPy * Uy
        fxch st(2)
        fmul Ux         ;EPx * Ux
        faddp
        faddp           ;iloczyn skalarny EPoU w ST(0)
        fld X
        fld Y
        fld Z
        fmul Wz         ;EPz * Wz
        fxch
        fmul Wy         ;EPy * Wy
        fxch st(2)
        fmul Wx         ;EPx * Wx
        faddp
        faddp           ;iloczyn skalarny EPoW w ST(0)
        fdivrp st(2)    ;ST(0)/ST(2) - EPoW / (EPoV * W)
        fdivrp st(2)    ;EPoU / (EPoV * U)
        fmul sy
        fadd yrespol
        fistp YY
        fmul sx
        fadd xrespol
        fistp XX

        mov eax,XX
        mov [di],eax
        mov eax,YY
        mov [di][4],eax
	ret

Invisible:
        ffree st
        ffree st(0)
        mov eax,0ffffh
        stosd
        mov eax,0ffffh
        stosd
        ret