;*****************************
;*  GOURAUD SHADED TRIANGLE  *
;*  CODE BY MOMAT            *
;*****************************
;konieczne:  zdefiniowane wartosci punktow tworzacych face'a X1,Y1,X2,Y2,X3,Y3
;            oraz ich kolorow K1,K2,K3 i bufora w segmencie Ekran
;zmienia:    eax,ebx,ecx,edx,ebp,di,es oraz flagi

.DATA
DX12    dd 0
DX13    dd 0
DX23    dd 0
X12     dd 0
X13     dd 0
X23     dd 0
DK12    dd 0
DK13    dd 0
DK23    dd 0
K12     dd 0
K13     dd 0
K23     dd 0
DK      dd 0
Ya      dw 0

.CODE
GouraudShade:
        mov ax,Ekran
        mov es,ax
        mov eax,Y1       ;porownanie i ustawienie punktow w kolejnosci
        cmp eax,Y3       ;rosnacej od Y1 do Y3
        jle MniejszeY1
        xchg eax,Y3
        mov Y1,eax
        mov eax,X1
        xchg eax,X3
        mov X1,eax
        mov eax,K1
        xchg eax,K3
        mov K1,eax
MniejszeY1:
        mov eax,Y2
        cmp eax,Y3
        jle MniejszeY2
        xchg eax,Y3
        mov Y2,eax
        mov eax,X2
        xchg eax,X3
        mov X2,eax
        mov eax,K2
        xchg eax,K3
        mov K2,eax
MniejszeY2:
        mov eax,Y1
        cmp eax,Y2
        jle LiczPrzyrosty
        xchg eax,Y2
        mov Y1,eax
        mov eax,X1
        xchg eax,X2
        mov X1,eax
        mov eax,K1
        xchg eax,K2
        mov K1,eax

LiczPrzyrosty:
        mov ebx,Y2       ;obliczanie DX12=(X2-X1)/(Y2-Y1)
        sub ebx,Y1
        je E0
        mov eax,X2
        shl eax,8        ;mnozenie dla zwiekszenia dokladnosci
        mov edx,X1
        shl edx,8        ;patrz wyzej
        sub eax,edx
        cdq
        idiv ebx
        mov DX12,eax

        mov eax,K2      ;obliczanie DK12=(K2-K1)/(Y2-Y1)
        shl eax,8
        mov edx,K1
        shl edx,8
        sub eax,edx
        cdq
        idiv ebx
        mov DK12,eax

E0:     mov ebx,Y1       ;obliczanie DX13=(X1-X3)/(Y1-Y3)
        sub ebx,Y3
        je E1
        mov eax,X1
        shl eax,8
        mov X13,eax
        mov X12,eax
        mov edx,X3
        shl edx,8
        sub eax,edx
        cdq
        idiv ebx
        mov DX13,eax

        mov eax,K1      ;obliczanie DK12=(K1-K3)/(Y1-Y3)
        shl eax,8
        mov K13,eax
        mov K12,eax
        mov edx,K3
        shl edx,8
        sub eax,edx
        cdq
        idiv ebx
        mov DK13,eax

E1:     mov ebx,Y2       ;obliczanie DX23=(X2-X3)/(Y2-Y3)
        sub ebx,Y3
        je E2
        mov eax,X2
        shl eax,8
        mov X23,eax
        mov edx,X3
        shl edx,8
        sub eax,edx
        cdq
        idiv ebx
        mov DX23,eax

        mov eax,K2      ;obliczanie DK23=(K2-K3)/(Y2-Y3)
        shl eax,8
        mov K23,eax
        mov edx,K3
        shl edx,8
        sub eax,edx
        cdq
        idiv ebx
        mov DK23,eax

E2:     mov eax,Y1       ;przygotowanie do rysowania linii
        mov Ya,ax
        mov ecx,Y2
        sub ecx,eax
        je NextPart     ;jesli w jednej linii to druga czesc trojkata
        push cx
        jmp Obliczenia1a

Obliczenia1:
        push cx
        cmp Ya,199      ;czy Ya = <0;199>
        jng NG
        pop cx
        jmp PowrotFlat
NG:     cmp Ya,0
        jnl NL
        jmp Obliczenia1a
NL:     shr eax,8
        shr ebx,8
        jmp Porownaj1

Obliczenia1a:
        mov eax,X12      ;obliczanie X12=X12+DX12
        add eax,DX12
        mov X12,eax
        mov ebx,X13      ;obliczanie X13=X13+DX13
        add ebx,DX13
        mov X13,ebx
        mov ebp,K12      ;obliczanie K12=K12+DK12
        add ebp,DK12
        mov K12,ebp
        mov edx,K13      ;obliczanie K13=K13+DK13
        add edx,DK13
        mov K13,edx
        inc Ya
        pop cx
	dec cx
        jne Obliczenia1

NextPart:
        mov ecx,Y3
        sub ecx,Y2
        je PowrotFlat    ;jesli w jednej linii to koniec rysowania
        mov eax,X23
        mov ebx,X13
        mov ebp,K23
        mov edx,K13

Obliczenia2:
        push cx
        cmp Ya,199      ;czy Ya = <0;199>
        jng NG3
        pop cx
        jmp PowrotFlat
NG3:    cmp Ya,0
        jnl NL3
        jmp Obliczenia2a
NL3:    shr eax,8
        shr ebx,8
        jmp Porownaj2

Obliczenia2a:
        mov eax,X23      ;obliczanie X23=X23+DX23
        add eax,DX23
        mov X23,eax
        mov ebx,X13      ;obliczanie X13=X13+DX13
        add ebx,DX13
        mov X13,ebx
        mov ebp,K23      ;obliczanie K23=K23+DK23
        add ebp,DK23
        mov K23,ebp
        mov edx,K13      ;obliczanie K13=K13+DK13
        add edx,DK13
        mov K13,edx
        inc Ya
        pop cx
	dec cx
        jne Obliczenia2

PowrotFlat:
        ret


Porownaj1:
        cmp ax,bx               ;sprawdzenie kolejnosci punktow
        jl Sprawdz1             ;ax=X12/X23, bx=X13/X13
        je Obliczenia1a         ;jezeli rowne, nie rysuj
        xchg ax,bx
        xchg edx,ebp

Sprawdz1:
        cmp ax,319      ;czy X12 < 319
        jl NG1
        jmp Obliczenia1a
NG1:    cmp bx,0        ;czy X13 > 0
        jle NS1
        call Reszta
NS1:    jmp Obliczenia1a

Porownaj2:
        cmp ax,bx
        jl Sprawdz2
        je Obliczenia2a
        xchg ax,bx
        xchg edx,ebp

Sprawdz2:
        cmp ax,319      ;czy X23 < 319
        jl NG4
        jmp Obliczenia2a
NG4:    cmp bx,0
        jle NS4
        call Reszta
NS4:    jmp Obliczenia2a

Reszta: push ax         ;obliczenie DK=(edx-ebp)/(bx-ax)
        movsx ecx,bx
        cwde
        sub ecx,eax
        mov eax,edx
        sub eax,ebp
        cdq
        idiv ecx
        mov DK,eax
        pop ax

        cmp bx,319      ;czy X13 < 319
        jng NG2
        mov bx,319
NG2:    cmp ax,0        ;czy X12/X23 > 0
        jnl Rysowanie
        neg ax
        cwde
        imul DK
        add ebp,eax
        xor eax,eax
Rysowanie:
        mov di,Ya
        mov cx,Ya
	shl di,8        ;mnozenie przez 256
        shl cx,6        ;mnozenie przez 64
        add di,cx
	mov cx,bx
        add di,ax       ;320*Ya + X12/X23
        sub cx,ax       ;przesuniecie punktu X13/X13 w buforze - cx
RysowaniePetla:
        mov eax,ebp
        shr eax,8        ;dzielenie dla uzyskania wartosci koloru
        stosb
        add ebp,DK
	dec cx
	jne RysowaniePetla
        ret
