.MODEL small
.386
.STACK 100h
.DATA

include green.pal

X       dw 48           ;przesuniecie punktu wzgledem
Y       dw 48           ;srodka obrotu
Xs      dw 160-64       ;flara na drodek ekranu
Ys      dw 100-64
XX      dw 0
YY      dw 0
Xp      dw 0            ;poczatek i koniec widocznego obszeru
Yp      dw 0
Xk      dw 0
Yk      dw 0


radian  dd 0.017453292519943296
Kat     dd 0.0
R       dw 0

FX      equ 128
FY      equ 128
FXX     dw FX/2
FYY     dw FY/2
file    db 'flara.raw',0
Rozmiar equ FX*FY
Flara   db Rozmiar dup(0)

file1   db 'pic.raw',0

Obrazek SEGMENT USE16 'Obrazek'
Picy    db 320*200 dup (0)
Obrazek ENDS

Ekran SEGMENT USE16 'EKRAN'
Bufor   db 320*200 dup (0)
Ekran ENDS

.CODE

Start: mov ax,_DATA
       mov ds,ax
       mov ax,0013h            ;inicjalizacja 13h
       int 10h
       call CzyscEkran
       call UstawPalete
       call WczytajFlare
       call WczytajObrazek
       mov ax,Ekran
       mov es,ax
       mov ax,Obrazek
       mov fs,ax

Main:  call CzyscBufor
       call Obroty              ;obrot flary
       call Obcinanie
       call Przerzuc            ;flara do bufora
       call Przelicz            ;przeksztalcenie obrazka wzgledem flary
       call NaEkran
       fld Kat
       fadd radian
       fstp Kat
       jmp Exit


Obroty:fld Kat
       fsincos
       fld st(1)
       fimul Y
       fld st(1)
       fimul X
       fsub
       fiadd Xs
       fistp XX
       fimul Y
       fxch st(1)
       fimul X
       fadd
       fiadd Ys
       fistp YY
       ret

Obcinanie:
       mov Xp,0
       mov Yp,0
       mov Xk,FX
       mov Yk,FY
       cmp YY,199-FY
       jle Next
       mov ax,199
       sub ax,YY
       jns Dodatnie
       xor ax,ax
Dodatnie:
       mov Yk,ax
Next:
       cmp YY,0
       jge Next1
       mov ax,YY
       neg ax
       cmp ax,FY
       jbe Mniejsze
       mov ax,FY
Mniejsze:
       mov Yp,ax
       mov YY,0
Next1:
       cmp XX,320-FX
       jle Next2
       mov ax,320
       sub ax,XX
       jns Dodatnie2
       xor ax,ax
Dodatnie2:
       mov Xk,ax
Next2:
       cmp XX,0
       jge Next3
       mov ax,XX
       neg ax
       cmp ax,FX
       jbe Mniejsze2
       mov ax,FX
Mniejsze2:
       mov Xp,ax
       mov XX,0
Next3: ret

Przerzuc:
       mov di,YY
       mov ax,di
       shl di,8
       shl ax,6
       add di,ax
       add di,XX
       lea si,Flara
       mov ax,Yp
       shl ax,7         ;mnoznik=FX
       add si,ax
       add si,Xp

       mov cx,Yk
       sub cx,Yp
       je PowrotPrzerzuc
PrzerzucPetla:
       push cx
       mov cx,Xk
       sub cx,Xp
       mov Yp,cx
       rep movsb
       add di,320
       sub di,Yp
       add si,FX
       sub si,Yp
       pop cx
       loop PrzerzucPetla
PowrotPrzerzuc:
       ret

Przelicz:
       xor si,si
       mov cx,320*200
PrzeliczPetla:
       xor bx,bx
       mov bl,es:[si]
       mov al,fs:[si][bx]
       mov es:[si],al
       inc si
       loop PrzeliczPetla
       ret


NaEkran:
       push es
       push ds
       mov ax,0a000h
       mov es,ax
       mov ax,Ekran
       mov ds,ax
       xor si,si
       xor di,di
       mov cx,320*200/4
       call Raster
       rep movsd
       pop ds
       pop es
       ret

CzyscBufor:
       xor di,di
       xor eax,eax
       mov cx,320*200/4
       rep stosd
       ret

WczytajFlare:
       mov ax,3d00h        ;otworzenie pliku
       lea dx,file
       int 21h
       jc ByeBye
       mov bx,ax           ;uchwyt pliku do bx
       mov ah,3fh          ;wczytanie pliku pod offset DS:DX
       lea dx,Flara
       mov cx,Rozmiar
       int 21h
       cmp ax,cx
       jne ByeBye
       mov ah,3eh          ;zamkniecie pliku
       int 21h
       ret

WczytajObrazek:
       mov ax,3d00h        ;otworzenie pliku
       lea dx,file1
       int 21h
       jc ByeBye
       mov bx,ax           ;uchwyt pliku do bx
       mov ah,3fh          ;wczytanie pliku pod offset DS:DX
       push ds
       mov dx,Obrazek
       mov ds,dx
       xor dx,dx
       mov cx,320*200
       int 21h
       cmp ax,cx
       jne ByeBye
       mov ah,3eh          ;zamkniecie pliku
       int 21h
       pop ds
       ret

UstawPalete:
       mov cx,768
       lea si,Pal
       mov dx,03c8h
       xor al,al
       out dx,al
       inc dx
       cld
       rep outsb
       ret

Exit:  mov ah,01h      ;klawisz
       int 16h
       jz Main
ByeBye:mov ax,0003h    ;tryb tekstowy
       int 10h
       mov ax,4c01h    ;DOS
       int 21h

CzyscEkran:
       mov ax,0a000h
       mov es,ax
       mov cx,64000/4
       xor di,di
       xor eax,eax
       cld
       rep stosd
       ret

Raster:
       mov dx,03dah
RasterPetla:
       in al,dx
       test al,8
       jz RasterPetla
       ret

Show:  mov cx,200
       xor di,di
       xor al,al
Loop1: push cx
       mov cx,255
Loop2: inc di
       inc al
       mov es:[di],al
       loop Loop2
       add di,320-255
       xor al,al
       pop cx
       loop Loop1
       jmp exit

END Start