.MODEL small
.386
.STACK 100h
.DATA

include fire.pal

FX      equ 128
FY      equ 128
shift   equ 7           ;log2(FX)

R       dw 60           ;promien obrotu
X       dw 0            ;wspolrzedne przeliczanego punktu
Y       dw 0

Xs      dw 160          ;wspolrzedne srodka
Ys      dw 100          ;ekranu
Lx      dw 0            ;wspolrzedne swiatla
Ly      dw 0            ;(srodek)
XX      dw 0            ;wspolrzedne flary
YY      dw 0

radian  dd 0.017453292519943296
Kat     dd 0.0

Xp      dw 0            ;poczatek i koniec widocznego obszeru
Yp      dw 0            ;(do obcinania)
Xk      dw 0
Yk      dw 0

file    db 'flara.raw',0
Flara SEGMENT USE16 'Flara'
BumpMapa db FX*FY dup (0)
Flara ENDS

file1   db 'pic.raw',0
Obrazek SEGMENT USE16 'Obrazek'
Picy    db 320*200 dup (0)
Obrazek ENDS

Ekran SEGMENT USE16 'EKRAN'
Bufor   db 320*200 dup (0)
Ekran ENDS


.CODE

Start: mov ax,_DATA
       mov ds,ax
       mov ax,0013h            ;inicjalizacja 13h
       int 10h
       call CzyscEkran
       call UstawPalete
       call WczytajFlare
       call WczytajObrazek
       mov ax,Ekran
       mov es,ax
       mov ax,Obrazek
       mov fs,ax
       mov ax,Flara
       mov gs,ax

Main:  call CzyscBufor
       call Obrot               ;obrot swiatla
       call Obcinanie
       call Przerzuc            ;flara do bufora
       call Przelicz            ;oblicz bumpa
       call NaEkran
       fld Kat
       fadd radian
       fstp Kat
       jmp Exit


Obrot: fld Kat
       fsincos
       fimul R
       fiadd Xs
       fistp Lx

       fimul R
       fiadd Ys
       fistp Ly
       ret

Obcinanie:
       mov Xp,0
       mov Yp,0
       mov Xk,FX
       mov Yk,FY
       mov ax,Lx
       mov bx,Ly
       sub ax,FX/2
       sub bx,FY/2
       mov XX,ax
       mov YY,bx
       cmp YY,199-FY
       jle Next
       mov ax,199
       sub ax,YY
       jns Dodatnie
       xor ax,ax
Dodatnie:
       mov Yk,ax
Next:
       cmp YY,0
       jge Next1
       mov ax,YY
       neg ax
       cmp ax,FY
       jbe Mniejsze
       mov ax,FY
Mniejsze:
       mov Yp,ax
       mov YY,0
Next1:
       cmp XX,320-FX
       jle Next2
       mov ax,320
       sub ax,XX
       jns Dodatnie2
       xor ax,ax
Dodatnie2:
       mov Xk,ax
Next2:
       cmp XX,0
       jge Next3
       mov ax,XX
       neg ax
       cmp ax,FX
       jbe Mniejsze2
       mov ax,FX
Mniejsze2:
       mov Xp,ax
       mov XX,0
Next3: ret

Przerzuc:
       mov di,YY
       mov ax,di
       shl di,8
       shl ax,6
       add di,ax
       add di,XX        ;di=offset ekranu
       mov ax,Yp
       shl ax,shift     ;mnozenie przez szerokosc flary
       mov si,ax
       add si,Xp        ;si=offset flary

       mov cx,Yk
       sub cx,Yp
       je PowrotPrzerzuc
PrzerzucPetla:
       push cx
       mov cx,Xk
       sub cx,Xp
       mov Yp,cx
       push ds
       mov ax,Flara
       mov ds,ax
       rep movsb
       pop ds
       add di,320
       sub di,Yp
       add si,FX
       sub si,Yp
       pop cx
       loop PrzerzucPetla
PowrotPrzerzuc:
       ret

Przelicz:
       mov Y,1
PrzeliczPetla2:
       mov X,1
PrzeliczPetla1:
       mov di,Y
       mov cx,di
       shl di,8        ;mnozenie przez 256
       shl cx,6        ;mnozenie przez 64
       add di,cx       ;(w sumie przez 320)
       add di,X        ;w di offset punktu (X,Y)

       mov al,fs:[di]
       shr al,3
       cmp BYTE PTR es:[di],0
       je Rysuj        ;jesli poza flara, rysuj kolorem tla

       ;oblicz wektor pseudonormalny
       movsx bx,BYTE PTR fs:[di][1]
       movsx bp,BYTE PTR fs:[di][-1]
       movsx cx,BYTE PTR fs:[di][320]
       movsx dx,BYTE PTR fs:[di][-320]
       sub bx,bp        ;bx=Nx
       sub cx,dx        ;cx=Ny

       sub bx,Lx        ;bx=Nx-(Lx-X)   (nachylenie - odleglosc)
       sub cx,Ly        ;cx=Ny-(Ly-Y)
       add bx,X
       add cx,Y

       ;sprawdz widocznosc punktu
       cmp bx,-FX/2
       jl NieWidoczny
       cmp bx,FX/2-1
       jg NieWidoczny
       cmp cx,-FY/2
       jl NieWidoczny
       cmp cx,FY/2-1
       jg NieWidoczny

       ;mapuj obszar wewnatrz flary
       add cx,FY/2
       add bx,FX/2
       shl cx,shift    ;mnozenie przez szerokosc flary (FX)
       mov si,bx
       add si,cx       ;w si offset punktu (Fx,Fy)
       mov al,gs:[si]
       jmp Rysuj
NieWidoczny:
       cmp BYTE PTR es:[di],0
       je Rysuj
       mov al,0        ;czarny, jesli wewnatrz flary i nie widoczny
Rysuj:
       mov es:[di],al
       inc X
       cmp X,319-1
       jne PrzeliczPetla1
       inc Y
       cmp Y,199-1
       jne PrzeliczPetla2
       ret

NaEkran:
       push es
       push ds
       mov ax,0a000h
       mov es,ax
       mov ax,Ekran
       mov ds,ax
       xor si,si
       xor di,di
       mov cx,320*200/4
       call Raster
       rep movsd
       pop ds
       pop es
       ret

CzyscBufor:
       xor di,di
       xor eax,eax
       mov cx,320*200/4
       rep stosd
       ret

WczytajFlare:
       mov ax,3d00h        ;otworzenie pliku
       lea dx,file
       int 21h
       jc ByeBye
       mov bx,ax           ;uchwyt pliku do bx
       mov ah,3fh          ;wczytanie pliku pod offset DS:DX
       push ds
       mov dx,Flara
       mov ds,dx
       xor dx,dx
       mov cx,FX*FY
       int 21h
       cmp ax,cx
       jne ByeBye
       mov ah,3eh          ;zamkniecie pliku
       int 21h
       pop ds
       ret

WczytajObrazek:
       mov ax,3d00h        ;otworzenie pliku
       lea dx,file1
       int 21h
       jc ByeBye
       mov bx,ax           ;uchwyt pliku do bx
       mov ah,3fh          ;wczytanie pliku pod offset DS:DX
       push ds
       mov dx,Obrazek
       mov ds,dx
       xor dx,dx
       mov cx,320*200
       int 21h
       cmp ax,cx
       jne ByeBye
       mov ah,3eh          ;zamkniecie pliku
       int 21h
       pop ds
       ret

UstawPalete:
       mov cx,768
       lea si,Pal
       mov dx,03c8h
       xor al,al
       out dx,al
       inc dx
       cld
       rep outsb
       ret

Exit:  mov ah,01h      ;klawisz
       int 16h
       jz Main
ByeBye:mov ax,0003h    ;tryb tekstowy
       int 10h
       mov ax,4c01h    ;DOS
       int 21h

CzyscEkran:
       mov ax,0a000h
       mov es,ax
       mov cx,64000/4
       xor di,di
       xor eax,eax
       cld
       rep stosd
       ret

Raster:
       mov dx,03dah
RasterPetla:
       in al,dx
       test al,8
       jz RasterPetla
       ret

Show:  mov cx,200
       xor di,di
       xor al,al
Loop1: push cx
       mov cx,255
Loop2: inc di
       inc al
       mov es:[di],al
       loop Loop2
       add di,320-255
       xor al,al
       pop cx
       loop Loop1
       jmp exit

END Start